/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mngdmac;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mngdmac.MacOrderAsyncClient;
import com.oracle.bmc.mngdmac.requests.CancelMacOrderRequest;
import com.oracle.bmc.mngdmac.requests.CancelWorkRequestRequest;
import com.oracle.bmc.mngdmac.requests.ChangeMacOrderCompartmentRequest;
import com.oracle.bmc.mngdmac.requests.CreateMacOrderRequest;
import com.oracle.bmc.mngdmac.requests.GetMacOrderRequest;
import com.oracle.bmc.mngdmac.requests.GetWorkRequestRequest;
import com.oracle.bmc.mngdmac.requests.ListMacOrdersRequest;
import com.oracle.bmc.mngdmac.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.mngdmac.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.mngdmac.requests.ListWorkRequestsRequest;
import com.oracle.bmc.mngdmac.requests.UpdateMacOrderRequest;
import com.oracle.bmc.mngdmac.responses.CancelMacOrderResponse;
import com.oracle.bmc.mngdmac.responses.CancelWorkRequestResponse;
import com.oracle.bmc.mngdmac.responses.ChangeMacOrderCompartmentResponse;
import com.oracle.bmc.mngdmac.responses.CreateMacOrderResponse;
import com.oracle.bmc.mngdmac.responses.GetMacOrderResponse;
import com.oracle.bmc.mngdmac.responses.GetWorkRequestResponse;
import com.oracle.bmc.mngdmac.responses.ListMacOrdersResponse;
import com.oracle.bmc.mngdmac.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.mngdmac.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.mngdmac.responses.ListWorkRequestsResponse;
import com.oracle.bmc.mngdmac.responses.UpdateMacOrderResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={MacOrderAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MacOrderRxClient {
    MacOrderAsyncClient client;

    MacOrderRxClient(MacOrderAsyncClient client) {
        this.client = client;
    }

    public Single<CancelMacOrderResponse> cancelMacOrder(CancelMacOrderRequest request) {
        return Single.create(emitter -> this.client.cancelMacOrder(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeMacOrderCompartmentResponse> changeMacOrderCompartment(ChangeMacOrderCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeMacOrderCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateMacOrderResponse> createMacOrder(CreateMacOrderRequest request) {
        return Single.create(emitter -> this.client.createMacOrder(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetMacOrderResponse> getMacOrder(GetMacOrderRequest request) {
        return Single.create(emitter -> this.client.getMacOrder(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListMacOrdersResponse> listMacOrders(ListMacOrdersRequest request) {
        return Single.create(emitter -> this.client.listMacOrders(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateMacOrderResponse> updateMacOrder(UpdateMacOrderRequest request) {
        return Single.create(emitter -> this.client.updateMacOrder(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

