/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mngdmac;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mngdmac.MacOrderAsyncClient;
import com.oracle.bmc.mngdmac.requests.CancelMacOrderRequest;
import com.oracle.bmc.mngdmac.requests.CancelWorkRequestRequest;
import com.oracle.bmc.mngdmac.requests.ChangeMacOrderCompartmentRequest;
import com.oracle.bmc.mngdmac.requests.CreateMacOrderRequest;
import com.oracle.bmc.mngdmac.requests.GetMacOrderRequest;
import com.oracle.bmc.mngdmac.requests.GetWorkRequestRequest;
import com.oracle.bmc.mngdmac.requests.ListMacOrdersRequest;
import com.oracle.bmc.mngdmac.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.mngdmac.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.mngdmac.requests.ListWorkRequestsRequest;
import com.oracle.bmc.mngdmac.requests.UpdateMacOrderRequest;
import com.oracle.bmc.mngdmac.responses.CancelMacOrderResponse;
import com.oracle.bmc.mngdmac.responses.CancelWorkRequestResponse;
import com.oracle.bmc.mngdmac.responses.ChangeMacOrderCompartmentResponse;
import com.oracle.bmc.mngdmac.responses.CreateMacOrderResponse;
import com.oracle.bmc.mngdmac.responses.GetMacOrderResponse;
import com.oracle.bmc.mngdmac.responses.GetWorkRequestResponse;
import com.oracle.bmc.mngdmac.responses.ListMacOrdersResponse;
import com.oracle.bmc.mngdmac.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.mngdmac.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.mngdmac.responses.ListWorkRequestsResponse;
import com.oracle.bmc.mngdmac.responses.UpdateMacOrderResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={MacOrderAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MacOrderReactorClient {
    MacOrderAsyncClient client;

    MacOrderReactorClient(MacOrderAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelMacOrderResponse> cancelMacOrder(CancelMacOrderRequest request) {
        return Mono.create(sink -> this.client.cancelMacOrder(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeMacOrderCompartmentResponse> changeMacOrderCompartment(ChangeMacOrderCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeMacOrderCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateMacOrderResponse> createMacOrder(CreateMacOrderRequest request) {
        return Mono.create(sink -> this.client.createMacOrder(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMacOrderResponse> getMacOrder(GetMacOrderRequest request) {
        return Mono.create(sink -> this.client.getMacOrder(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMacOrdersResponse> listMacOrders(ListMacOrdersRequest request) {
        return Mono.create(sink -> this.client.listMacOrders(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateMacOrderResponse> updateMacOrder(UpdateMacOrderRequest request) {
        return Mono.create(sink -> this.client.updateMacOrder(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

