/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.mngdmac;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mngdmac.MacDeviceAsyncClient;
import com.oracle.bmc.mngdmac.requests.GetMacDeviceRequest;
import com.oracle.bmc.mngdmac.requests.ListMacDevicesRequest;
import com.oracle.bmc.mngdmac.requests.TerminateMacDeviceRequest;
import com.oracle.bmc.mngdmac.responses.GetMacDeviceResponse;
import com.oracle.bmc.mngdmac.responses.ListMacDevicesResponse;
import com.oracle.bmc.mngdmac.responses.TerminateMacDeviceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={MacDeviceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MacDeviceReactorClient {
    MacDeviceAsyncClient client;

    MacDeviceReactorClient(MacDeviceAsyncClient client) {
        this.client = client;
    }

    public Mono<GetMacDeviceResponse> getMacDevice(GetMacDeviceRequest request) {
        return Mono.create(sink -> this.client.getMacDevice(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMacDevicesResponse> listMacDevices(ListMacDevicesRequest request) {
        return Mono.create(sink -> this.client.listMacDevices(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<TerminateMacDeviceResponse> terminateMacDevice(TerminateMacDeviceRequest request) {
        return Mono.create(sink -> this.client.terminateMacDevice(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

