/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.loggingingestion;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.loggingingestion.LoggingAsyncClient;
import com.oracle.bmc.loggingingestion.requests.PutLogsRequest;
import com.oracle.bmc.loggingingestion.responses.PutLogsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={LoggingAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class LoggingReactorClient {
    LoggingAsyncClient client;

    LoggingReactorClient(LoggingAsyncClient client) {
        this.client = client;
    }

    public Mono<PutLogsResponse> putLogs(PutLogsRequest request) {
        return Mono.create(sink -> this.client.putLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

