/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsVaultAsyncClient;
import com.oracle.bmc.keymanagement.requests.BackupVaultRequest;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.DeleteVaultReplicaRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultUsageRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultReplicasRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.BackupVaultResponse;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.DeleteVaultReplicaResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultUsageResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultReplicasResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={KmsVaultAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsVaultReactorClient {
    KmsVaultAsyncClient client;

    KmsVaultReactorClient(KmsVaultAsyncClient client) {
        this.client = client;
    }

    public Mono<BackupVaultResponse> backupVault(BackupVaultRequest request) {
        return Mono.create(sink -> this.client.backupVault(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelVaultDeletionResponse> cancelVaultDeletion(CancelVaultDeletionRequest request) {
        return Mono.create(sink -> this.client.cancelVaultDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeVaultCompartmentResponse> changeVaultCompartment(ChangeVaultCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeVaultCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateVaultResponse> createVault(CreateVaultRequest request) {
        return Mono.create(sink -> this.client.createVault(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateVaultReplicaResponse> createVaultReplica(CreateVaultReplicaRequest request) {
        return Mono.create(sink -> this.client.createVaultReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteVaultReplicaResponse> deleteVaultReplica(DeleteVaultReplicaRequest request) {
        return Mono.create(sink -> this.client.deleteVaultReplica(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetVaultResponse> getVault(GetVaultRequest request) {
        return Mono.create(sink -> this.client.getVault(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetVaultUsageResponse> getVaultUsage(GetVaultUsageRequest request) {
        return Mono.create(sink -> this.client.getVaultUsage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListVaultReplicasResponse> listVaultReplicas(ListVaultReplicasRequest request) {
        return Mono.create(sink -> this.client.listVaultReplicas(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListVaultsResponse> listVaults(ListVaultsRequest request) {
        return Mono.create(sink -> this.client.listVaults(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestoreVaultFromFileResponse> restoreVaultFromFile(RestoreVaultFromFileRequest request) {
        return Mono.create(sink -> this.client.restoreVaultFromFile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestoreVaultFromObjectStoreResponse> restoreVaultFromObjectStore(RestoreVaultFromObjectStoreRequest request) {
        return Mono.create(sink -> this.client.restoreVaultFromObjectStore(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ScheduleVaultDeletionResponse> scheduleVaultDeletion(ScheduleVaultDeletionRequest request) {
        return Mono.create(sink -> this.client.scheduleVaultDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateVaultResponse> updateVault(UpdateVaultRequest request) {
        return Mono.create(sink -> this.client.updateVault(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

