/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsManagementAsyncClient;
import com.oracle.bmc.keymanagement.requests.BackupKeyRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeKeyCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.DisableKeyRequest;
import com.oracle.bmc.keymanagement.requests.EnableKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.GetReplicationStatusRequest;
import com.oracle.bmc.keymanagement.requests.GetWrappingKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateKeyRequest;
import com.oracle.bmc.keymanagement.responses.BackupKeyResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeKeyCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.DisableKeyResponse;
import com.oracle.bmc.keymanagement.responses.EnableKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.GetReplicationStatusResponse;
import com.oracle.bmc.keymanagement.responses.GetWrappingKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateKeyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={KmsManagementAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsManagementReactorClient {
    KmsManagementAsyncClient client;

    KmsManagementReactorClient(KmsManagementAsyncClient client) {
        this.client = client;
    }

    public Mono<BackupKeyResponse> backupKey(BackupKeyRequest request) {
        return Mono.create(sink -> this.client.backupKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelKeyDeletionResponse> cancelKeyDeletion(CancelKeyDeletionRequest request) {
        return Mono.create(sink -> this.client.cancelKeyDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelKeyVersionDeletionResponse> cancelKeyVersionDeletion(CancelKeyVersionDeletionRequest request) {
        return Mono.create(sink -> this.client.cancelKeyVersionDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeKeyCompartmentResponse> changeKeyCompartment(ChangeKeyCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeKeyCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateKeyResponse> createKey(CreateKeyRequest request) {
        return Mono.create(sink -> this.client.createKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateKeyVersionResponse> createKeyVersion(CreateKeyVersionRequest request) {
        return Mono.create(sink -> this.client.createKeyVersion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DisableKeyResponse> disableKey(DisableKeyRequest request) {
        return Mono.create(sink -> this.client.disableKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<EnableKeyResponse> enableKey(EnableKeyRequest request) {
        return Mono.create(sink -> this.client.enableKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetKeyResponse> getKey(GetKeyRequest request) {
        return Mono.create(sink -> this.client.getKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetKeyVersionResponse> getKeyVersion(GetKeyVersionRequest request) {
        return Mono.create(sink -> this.client.getKeyVersion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetReplicationStatusResponse> getReplicationStatus(GetReplicationStatusRequest request) {
        return Mono.create(sink -> this.client.getReplicationStatus(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWrappingKeyResponse> getWrappingKey(GetWrappingKeyRequest request) {
        return Mono.create(sink -> this.client.getWrappingKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ImportKeyResponse> importKey(ImportKeyRequest request) {
        return Mono.create(sink -> this.client.importKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ImportKeyVersionResponse> importKeyVersion(ImportKeyVersionRequest request) {
        return Mono.create(sink -> this.client.importKeyVersion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListKeyVersionsResponse> listKeyVersions(ListKeyVersionsRequest request) {
        return Mono.create(sink -> this.client.listKeyVersions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListKeysResponse> listKeys(ListKeysRequest request) {
        return Mono.create(sink -> this.client.listKeys(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestoreKeyFromFileResponse> restoreKeyFromFile(RestoreKeyFromFileRequest request) {
        return Mono.create(sink -> this.client.restoreKeyFromFile(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RestoreKeyFromObjectStoreResponse> restoreKeyFromObjectStore(RestoreKeyFromObjectStoreRequest request) {
        return Mono.create(sink -> this.client.restoreKeyFromObjectStore(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ScheduleKeyDeletionResponse> scheduleKeyDeletion(ScheduleKeyDeletionRequest request) {
        return Mono.create(sink -> this.client.scheduleKeyDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ScheduleKeyVersionDeletionResponse> scheduleKeyVersionDeletion(ScheduleKeyVersionDeletionRequest request) {
        return Mono.create(sink -> this.client.scheduleKeyVersionDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateKeyResponse> updateKey(UpdateKeyRequest request) {
        return Mono.create(sink -> this.client.updateKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

