/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsHsmClusterAsyncClient;
import com.oracle.bmc.keymanagement.requests.CancelHsmClusterDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeHsmClusterCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.DownloadCertificateSigningRequestRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmPartitionRequest;
import com.oracle.bmc.keymanagement.requests.GetPreCoUserCredentialsRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmClustersRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmPartitionsRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleHsmClusterDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.UploadPartitionCertificatesRequest;
import com.oracle.bmc.keymanagement.responses.CancelHsmClusterDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeHsmClusterCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.DownloadCertificateSigningRequestResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmPartitionResponse;
import com.oracle.bmc.keymanagement.responses.GetPreCoUserCredentialsResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmClustersResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmPartitionsResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleHsmClusterDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.UploadPartitionCertificatesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={KmsHsmClusterAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsHsmClusterReactorClient {
    KmsHsmClusterAsyncClient client;

    KmsHsmClusterReactorClient(KmsHsmClusterAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelHsmClusterDeletionResponse> cancelHsmClusterDeletion(CancelHsmClusterDeletionRequest request) {
        return Mono.create(sink -> this.client.cancelHsmClusterDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeHsmClusterCompartmentResponse> changeHsmClusterCompartment(ChangeHsmClusterCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeHsmClusterCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateHsmClusterResponse> createHsmCluster(CreateHsmClusterRequest request) {
        return Mono.create(sink -> this.client.createHsmCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DownloadCertificateSigningRequestResponse> downloadCertificateSigningRequest(DownloadCertificateSigningRequestRequest request) {
        return Mono.create(sink -> this.client.downloadCertificateSigningRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetHsmClusterResponse> getHsmCluster(GetHsmClusterRequest request) {
        return Mono.create(sink -> this.client.getHsmCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetHsmPartitionResponse> getHsmPartition(GetHsmPartitionRequest request) {
        return Mono.create(sink -> this.client.getHsmPartition(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPreCoUserCredentialsResponse> getPreCoUserCredentials(GetPreCoUserCredentialsRequest request) {
        return Mono.create(sink -> this.client.getPreCoUserCredentials(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListHsmClustersResponse> listHsmClusters(ListHsmClustersRequest request) {
        return Mono.create(sink -> this.client.listHsmClusters(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListHsmPartitionsResponse> listHsmPartitions(ListHsmPartitionsRequest request) {
        return Mono.create(sink -> this.client.listHsmPartitions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ScheduleHsmClusterDeletionResponse> scheduleHsmClusterDeletion(ScheduleHsmClusterDeletionRequest request) {
        return Mono.create(sink -> this.client.scheduleHsmClusterDeletion(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateHsmClusterResponse> updateHsmCluster(UpdateHsmClusterRequest request) {
        return Mono.create(sink -> this.client.updateHsmCluster(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UploadPartitionCertificatesResponse> uploadPartitionCertificates(UploadPartitionCertificatesRequest request) {
        return Mono.create(sink -> this.client.uploadPartitionCertificates(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

