/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsCryptoAsyncClient;
import com.oracle.bmc.keymanagement.requests.DecryptRequest;
import com.oracle.bmc.keymanagement.requests.EncryptRequest;
import com.oracle.bmc.keymanagement.requests.ExportKeyRequest;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.requests.SignRequest;
import com.oracle.bmc.keymanagement.requests.VerifyRequest;
import com.oracle.bmc.keymanagement.responses.DecryptResponse;
import com.oracle.bmc.keymanagement.responses.EncryptResponse;
import com.oracle.bmc.keymanagement.responses.ExportKeyResponse;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import com.oracle.bmc.keymanagement.responses.SignResponse;
import com.oracle.bmc.keymanagement.responses.VerifyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={KmsCryptoAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsCryptoReactorClient {
    KmsCryptoAsyncClient client;

    KmsCryptoReactorClient(KmsCryptoAsyncClient client) {
        this.client = client;
    }

    public Mono<DecryptResponse> decrypt(DecryptRequest request) {
        return Mono.create(sink -> this.client.decrypt(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<EncryptResponse> encrypt(EncryptRequest request) {
        return Mono.create(sink -> this.client.encrypt(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ExportKeyResponse> exportKey(ExportKeyRequest request) {
        return Mono.create(sink -> this.client.exportKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GenerateDataEncryptionKeyResponse> generateDataEncryptionKey(GenerateDataEncryptionKeyRequest request) {
        return Mono.create(sink -> this.client.generateDataEncryptionKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SignResponse> sign(SignRequest request) {
        return Mono.create(sink -> this.client.sign(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<VerifyResponse> verify(VerifyRequest request) {
        return Mono.create(sink -> this.client.verify(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

