/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.EkmAsyncClient;
import com.oracle.bmc.keymanagement.requests.CreateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.DeleteEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.GetEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.ListEkmsPrivateEndpointsRequest;
import com.oracle.bmc.keymanagement.requests.UpdateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.responses.CreateEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.DeleteEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.GetEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.ListEkmsPrivateEndpointsResponse;
import com.oracle.bmc.keymanagement.responses.UpdateEkmsPrivateEndpointResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={EkmAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EkmReactorClient {
    EkmAsyncClient client;

    EkmReactorClient(EkmAsyncClient client) {
        this.client = client;
    }

    public Mono<CreateEkmsPrivateEndpointResponse> createEkmsPrivateEndpoint(CreateEkmsPrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.createEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteEkmsPrivateEndpointResponse> deleteEkmsPrivateEndpoint(DeleteEkmsPrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.deleteEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEkmsPrivateEndpointResponse> getEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.getEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEkmsPrivateEndpointsResponse> listEkmsPrivateEndpoints(ListEkmsPrivateEndpointsRequest request) {
        return Mono.create(sink -> this.client.listEkmsPrivateEndpoints(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateEkmsPrivateEndpointResponse> updateEkmsPrivateEndpoint(UpdateEkmsPrivateEndpointRequest request) {
        return Mono.create(sink -> this.client.updateEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

