/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.InternalBuilderAccess;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.keymanagement.EkmClient;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.oraclecloud.core.sdk.AbstractSdkClientFactory;
import jakarta.inject.Singleton;

@Factory
@Requires(classes={EkmClient.class}, beans={AbstractAuthenticationDetailsProvider.class})
public final class EkmClientFactory
extends AbstractSdkClientFactory<EkmClient.Builder, EkmClient> {
    private EkmClient.Builder builder = (EkmClient.Builder)super.getBuilder();
    private RegionProvider regionProvider;

    protected EkmClientFactory(ClientConfiguration clientConfiguration, @Nullable ClientConfigurator clientConfigurator, @Nullable RequestSignerFactory requestSignerFactory, @Nullable RegionProvider regionProvider) {
        super((ClientBuilderBase)EkmClient.builder(), clientConfiguration, clientConfigurator, requestSignerFactory, regionProvider);
        this.regionProvider = regionProvider;
    }

    @Singleton
    @Requires(classes={EkmClient.class}, beans={AbstractAuthenticationDetailsProvider.class})
    protected EkmClient.Builder getBuilder() {
        return (EkmClient.Builder)super.getBuilder();
    }

    @Singleton
    @Requires(classes={EkmClient.class}, beans={AbstractAuthenticationDetailsProvider.class})
    @Bean(preDestroy="close")
    protected EkmClient build(EkmClient.Builder clientBuilder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        return this.regionProvider != null && this.regionProvider.getRegion() != null && InternalBuilderAccess.getEndpoint((ClientBuilderBase)clientBuilder) == null ? ((EkmClient.Builder)clientBuilder.region(this.regionProvider.getRegion())).build(authenticationDetailsProvider) : clientBuilder.build(authenticationDetailsProvider);
    }
}

