/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.integration;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.integration.IntegrationInstanceAsyncClient;
import com.oracle.bmc.integration.requests.AddOracleManagedCustomEndpointRequest;
import com.oracle.bmc.integration.requests.ChangeIntegrationInstanceCompartmentRequest;
import com.oracle.bmc.integration.requests.ChangeIntegrationInstanceNetworkEndpointRequest;
import com.oracle.bmc.integration.requests.ChangePrivateEndpointOutboundConnectionRequest;
import com.oracle.bmc.integration.requests.CreateIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.DeleteIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.DisasterRecoveryFailoverRequest;
import com.oracle.bmc.integration.requests.EnableProcessAutomationRequest;
import com.oracle.bmc.integration.requests.ExtendDataRetentionRequest;
import com.oracle.bmc.integration.requests.GetIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.GetWorkRequestRequest;
import com.oracle.bmc.integration.requests.ListIntegrationInstancesRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.integration.requests.RemoveOracleManagedCustomEndpointRequest;
import com.oracle.bmc.integration.requests.StartIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.StopIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.UpdateIntegrationInstanceRequest;
import com.oracle.bmc.integration.responses.AddOracleManagedCustomEndpointResponse;
import com.oracle.bmc.integration.responses.ChangeIntegrationInstanceCompartmentResponse;
import com.oracle.bmc.integration.responses.ChangeIntegrationInstanceNetworkEndpointResponse;
import com.oracle.bmc.integration.responses.ChangePrivateEndpointOutboundConnectionResponse;
import com.oracle.bmc.integration.responses.CreateIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.DeleteIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.DisasterRecoveryFailoverResponse;
import com.oracle.bmc.integration.responses.EnableProcessAutomationResponse;
import com.oracle.bmc.integration.responses.ExtendDataRetentionResponse;
import com.oracle.bmc.integration.responses.GetIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.GetWorkRequestResponse;
import com.oracle.bmc.integration.responses.ListIntegrationInstancesResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.integration.responses.RemoveOracleManagedCustomEndpointResponse;
import com.oracle.bmc.integration.responses.StartIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.StopIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.UpdateIntegrationInstanceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={IntegrationInstanceAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class IntegrationInstanceReactorClient {
    IntegrationInstanceAsyncClient client;

    IntegrationInstanceReactorClient(IntegrationInstanceAsyncClient client) {
        this.client = client;
    }

    public Mono<AddOracleManagedCustomEndpointResponse> addOracleManagedCustomEndpoint(AddOracleManagedCustomEndpointRequest request) {
        return Mono.create(sink -> this.client.addOracleManagedCustomEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeIntegrationInstanceCompartmentResponse> changeIntegrationInstanceCompartment(ChangeIntegrationInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeIntegrationInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeIntegrationInstanceNetworkEndpointResponse> changeIntegrationInstanceNetworkEndpoint(ChangeIntegrationInstanceNetworkEndpointRequest request) {
        return Mono.create(sink -> this.client.changeIntegrationInstanceNetworkEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangePrivateEndpointOutboundConnectionResponse> changePrivateEndpointOutboundConnection(ChangePrivateEndpointOutboundConnectionRequest request) {
        return Mono.create(sink -> this.client.changePrivateEndpointOutboundConnection(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateIntegrationInstanceResponse> createIntegrationInstance(CreateIntegrationInstanceRequest request) {
        return Mono.create(sink -> this.client.createIntegrationInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteIntegrationInstanceResponse> deleteIntegrationInstance(DeleteIntegrationInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteIntegrationInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DisasterRecoveryFailoverResponse> disasterRecoveryFailover(DisasterRecoveryFailoverRequest request) {
        return Mono.create(sink -> this.client.disasterRecoveryFailover(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<EnableProcessAutomationResponse> enableProcessAutomation(EnableProcessAutomationRequest request) {
        return Mono.create(sink -> this.client.enableProcessAutomation(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ExtendDataRetentionResponse> extendDataRetention(ExtendDataRetentionRequest request) {
        return Mono.create(sink -> this.client.extendDataRetention(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetIntegrationInstanceResponse> getIntegrationInstance(GetIntegrationInstanceRequest request) {
        return Mono.create(sink -> this.client.getIntegrationInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListIntegrationInstancesResponse> listIntegrationInstances(ListIntegrationInstancesRequest request) {
        return Mono.create(sink -> this.client.listIntegrationInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveOracleManagedCustomEndpointResponse> removeOracleManagedCustomEndpoint(RemoveOracleManagedCustomEndpointRequest request) {
        return Mono.create(sink -> this.client.removeOracleManagedCustomEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartIntegrationInstanceResponse> startIntegrationInstance(StartIntegrationInstanceRequest request) {
        return Mono.create(sink -> this.client.startIntegrationInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StopIntegrationInstanceResponse> stopIntegrationInstance(StopIntegrationInstanceRequest request) {
        return Mono.create(sink -> this.client.stopIntegrationInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateIntegrationInstanceResponse> updateIntegrationInstance(UpdateIntegrationInstanceRequest request) {
        return Mono.create(sink -> this.client.updateIntegrationInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

