/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.generativeaiagent;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.generativeaiagent.GenerativeAiAgentAsyncClient;
import com.oracle.bmc.generativeaiagent.requests.CancelWorkRequestRequest;
import com.oracle.bmc.generativeaiagent.requests.ChangeAgentCompartmentRequest;
import com.oracle.bmc.generativeaiagent.requests.ChangeAgentEndpointCompartmentRequest;
import com.oracle.bmc.generativeaiagent.requests.ChangeKnowledgeBaseCompartmentRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.CreateToolRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.DeleteToolRequest;
import com.oracle.bmc.generativeaiagent.requests.GetAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.GetAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataIngestionJobLogContentRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataIngestionJobRequest;
import com.oracle.bmc.generativeaiagent.requests.GetDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.GetToolRequest;
import com.oracle.bmc.generativeaiagent.requests.GetWorkRequestRequest;
import com.oracle.bmc.generativeaiagent.requests.ListAgentEndpointsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListAgentsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListDataIngestionJobsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListDataSourcesRequest;
import com.oracle.bmc.generativeaiagent.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.generativeaiagent.requests.ListToolsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.generativeaiagent.requests.ListWorkRequestsRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateAgentEndpointRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateAgentRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateDataSourceRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateKnowledgeBaseRequest;
import com.oracle.bmc.generativeaiagent.requests.UpdateToolRequest;
import com.oracle.bmc.generativeaiagent.responses.CancelWorkRequestResponse;
import com.oracle.bmc.generativeaiagent.responses.ChangeAgentCompartmentResponse;
import com.oracle.bmc.generativeaiagent.responses.ChangeAgentEndpointCompartmentResponse;
import com.oracle.bmc.generativeaiagent.responses.ChangeKnowledgeBaseCompartmentResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.CreateToolResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.DeleteToolResponse;
import com.oracle.bmc.generativeaiagent.responses.GetAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.GetAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataIngestionJobLogContentResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataIngestionJobResponse;
import com.oracle.bmc.generativeaiagent.responses.GetDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.GetToolResponse;
import com.oracle.bmc.generativeaiagent.responses.GetWorkRequestResponse;
import com.oracle.bmc.generativeaiagent.responses.ListAgentEndpointsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListAgentsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListDataIngestionJobsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListDataSourcesResponse;
import com.oracle.bmc.generativeaiagent.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.generativeaiagent.responses.ListToolsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.generativeaiagent.responses.ListWorkRequestsResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateAgentEndpointResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateAgentResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateDataSourceResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateKnowledgeBaseResponse;
import com.oracle.bmc.generativeaiagent.responses.UpdateToolResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={GenerativeAiAgentAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GenerativeAiAgentReactorClient {
    GenerativeAiAgentAsyncClient client;

    GenerativeAiAgentReactorClient(GenerativeAiAgentAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAgentCompartmentResponse> changeAgentCompartment(ChangeAgentCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAgentCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAgentEndpointCompartmentResponse> changeAgentEndpointCompartment(ChangeAgentEndpointCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAgentEndpointCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeKnowledgeBaseCompartmentResponse> changeKnowledgeBaseCompartment(ChangeKnowledgeBaseCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeKnowledgeBaseCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAgentResponse> createAgent(CreateAgentRequest request) {
        return Mono.create(sink -> this.client.createAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAgentEndpointResponse> createAgentEndpoint(CreateAgentEndpointRequest request) {
        return Mono.create(sink -> this.client.createAgentEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDataIngestionJobResponse> createDataIngestionJob(CreateDataIngestionJobRequest request) {
        return Mono.create(sink -> this.client.createDataIngestionJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest request) {
        return Mono.create(sink -> this.client.createDataSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateKnowledgeBaseResponse> createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.createKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateToolResponse> createTool(CreateToolRequest request) {
        return Mono.create(sink -> this.client.createTool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAgentResponse> deleteAgent(DeleteAgentRequest request) {
        return Mono.create(sink -> this.client.deleteAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAgentEndpointResponse> deleteAgentEndpoint(DeleteAgentEndpointRequest request) {
        return Mono.create(sink -> this.client.deleteAgentEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDataIngestionJobResponse> deleteDataIngestionJob(DeleteDataIngestionJobRequest request) {
        return Mono.create(sink -> this.client.deleteDataIngestionJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest request) {
        return Mono.create(sink -> this.client.deleteDataSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.deleteKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteToolResponse> deleteTool(DeleteToolRequest request) {
        return Mono.create(sink -> this.client.deleteTool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAgentResponse> getAgent(GetAgentRequest request) {
        return Mono.create(sink -> this.client.getAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAgentEndpointResponse> getAgentEndpoint(GetAgentEndpointRequest request) {
        return Mono.create(sink -> this.client.getAgentEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDataIngestionJobResponse> getDataIngestionJob(GetDataIngestionJobRequest request) {
        return Mono.create(sink -> this.client.getDataIngestionJob(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDataIngestionJobLogContentResponse> getDataIngestionJobLogContent(GetDataIngestionJobLogContentRequest request) {
        return Mono.create(sink -> this.client.getDataIngestionJobLogContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDataSourceResponse> getDataSource(GetDataSourceRequest request) {
        return Mono.create(sink -> this.client.getDataSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetKnowledgeBaseResponse> getKnowledgeBase(GetKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.getKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetToolResponse> getTool(GetToolRequest request) {
        return Mono.create(sink -> this.client.getTool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAgentEndpointsResponse> listAgentEndpoints(ListAgentEndpointsRequest request) {
        return Mono.create(sink -> this.client.listAgentEndpoints(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAgentsResponse> listAgents(ListAgentsRequest request) {
        return Mono.create(sink -> this.client.listAgents(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDataIngestionJobsResponse> listDataIngestionJobs(ListDataIngestionJobsRequest request) {
        return Mono.create(sink -> this.client.listDataIngestionJobs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest request) {
        return Mono.create(sink -> this.client.listDataSources(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListKnowledgeBasesResponse> listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return Mono.create(sink -> this.client.listKnowledgeBases(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListToolsResponse> listTools(ListToolsRequest request) {
        return Mono.create(sink -> this.client.listTools(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAgentResponse> updateAgent(UpdateAgentRequest request) {
        return Mono.create(sink -> this.client.updateAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAgentEndpointResponse> updateAgentEndpoint(UpdateAgentEndpointRequest request) {
        return Mono.create(sink -> this.client.updateAgentEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest request) {
        return Mono.create(sink -> this.client.updateDataSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateKnowledgeBaseResponse> updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.updateKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateToolResponse> updateTool(UpdateToolRequest request) {
        return Mono.create(sink -> this.client.updateTool(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

