/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.datalabelingservice;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.datalabelingservice.DataLabelingManagementAsyncClient;
import com.oracle.bmc.datalabelingservice.requests.AddDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.ChangeDatasetCompartmentRequest;
import com.oracle.bmc.datalabelingservice.requests.CreateDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.DeleteDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GenerateDatasetRecordsRequest;
import com.oracle.bmc.datalabelingservice.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GetWorkRequestRequest;
import com.oracle.bmc.datalabelingservice.requests.ImportPreAnnotatedDataRequest;
import com.oracle.bmc.datalabelingservice.requests.ListAnnotationFormatsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListDatasetsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datalabelingservice.requests.RemoveDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.RenameDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.SnapshotDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.UpdateDatasetRequest;
import com.oracle.bmc.datalabelingservice.responses.AddDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.ChangeDatasetCompartmentResponse;
import com.oracle.bmc.datalabelingservice.responses.CreateDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.DeleteDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GenerateDatasetRecordsResponse;
import com.oracle.bmc.datalabelingservice.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GetWorkRequestResponse;
import com.oracle.bmc.datalabelingservice.responses.ImportPreAnnotatedDataResponse;
import com.oracle.bmc.datalabelingservice.responses.ListAnnotationFormatsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListDatasetsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datalabelingservice.responses.RemoveDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.RenameDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.SnapshotDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.UpdateDatasetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DataLabelingManagementAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DataLabelingManagementRxClient {
    DataLabelingManagementAsyncClient client;

    DataLabelingManagementRxClient(DataLabelingManagementAsyncClient client) {
        this.client = client;
    }

    public Single<AddDatasetLabelsResponse> addDatasetLabels(AddDatasetLabelsRequest request) {
        return Single.create(emitter -> this.client.addDatasetLabels(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeDatasetCompartmentResponse> changeDatasetCompartment(ChangeDatasetCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeDatasetCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateDatasetResponse> createDataset(CreateDatasetRequest request) {
        return Single.create(emitter -> this.client.createDataset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest request) {
        return Single.create(emitter -> this.client.deleteDataset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GenerateDatasetRecordsResponse> generateDatasetRecords(GenerateDatasetRecordsRequest request) {
        return Single.create(emitter -> this.client.generateDatasetRecords(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetDatasetResponse> getDataset(GetDatasetRequest request) {
        return Single.create(emitter -> this.client.getDataset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ImportPreAnnotatedDataResponse> importPreAnnotatedData(ImportPreAnnotatedDataRequest request) {
        return Single.create(emitter -> this.client.importPreAnnotatedData(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAnnotationFormatsResponse> listAnnotationFormats(ListAnnotationFormatsRequest request) {
        return Single.create(emitter -> this.client.listAnnotationFormats(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListDatasetsResponse> listDatasets(ListDatasetsRequest request) {
        return Single.create(emitter -> this.client.listDatasets(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveDatasetLabelsResponse> removeDatasetLabels(RemoveDatasetLabelsRequest request) {
        return Single.create(emitter -> this.client.removeDatasetLabels(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RenameDatasetLabelsResponse> renameDatasetLabels(RenameDatasetLabelsRequest request) {
        return Single.create(emitter -> this.client.renameDatasetLabels(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SnapshotDatasetResponse> snapshotDataset(SnapshotDatasetRequest request) {
        return Single.create(emitter -> this.client.snapshotDataset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateDatasetResponse> updateDataset(UpdateDatasetRequest request) {
        return Single.create(emitter -> this.client.updateDataset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

