/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.datalabelingservice;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.datalabelingservice.DataLabelingManagementAsyncClient;
import com.oracle.bmc.datalabelingservice.requests.AddDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.ChangeDatasetCompartmentRequest;
import com.oracle.bmc.datalabelingservice.requests.CreateDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.DeleteDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GenerateDatasetRecordsRequest;
import com.oracle.bmc.datalabelingservice.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GetWorkRequestRequest;
import com.oracle.bmc.datalabelingservice.requests.ImportPreAnnotatedDataRequest;
import com.oracle.bmc.datalabelingservice.requests.ListAnnotationFormatsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListDatasetsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datalabelingservice.requests.RemoveDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.RenameDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.SnapshotDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.UpdateDatasetRequest;
import com.oracle.bmc.datalabelingservice.responses.AddDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.ChangeDatasetCompartmentResponse;
import com.oracle.bmc.datalabelingservice.responses.CreateDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.DeleteDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GenerateDatasetRecordsResponse;
import com.oracle.bmc.datalabelingservice.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GetWorkRequestResponse;
import com.oracle.bmc.datalabelingservice.responses.ImportPreAnnotatedDataResponse;
import com.oracle.bmc.datalabelingservice.responses.ListAnnotationFormatsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListDatasetsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datalabelingservice.responses.RemoveDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.RenameDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.SnapshotDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.UpdateDatasetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DataLabelingManagementAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DataLabelingManagementReactorClient {
    DataLabelingManagementAsyncClient client;

    DataLabelingManagementReactorClient(DataLabelingManagementAsyncClient client) {
        this.client = client;
    }

    public Mono<AddDatasetLabelsResponse> addDatasetLabels(AddDatasetLabelsRequest request) {
        return Mono.create(sink -> this.client.addDatasetLabels(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeDatasetCompartmentResponse> changeDatasetCompartment(ChangeDatasetCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeDatasetCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDatasetResponse> createDataset(CreateDatasetRequest request) {
        return Mono.create(sink -> this.client.createDataset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest request) {
        return Mono.create(sink -> this.client.deleteDataset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GenerateDatasetRecordsResponse> generateDatasetRecords(GenerateDatasetRecordsRequest request) {
        return Mono.create(sink -> this.client.generateDatasetRecords(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDatasetResponse> getDataset(GetDatasetRequest request) {
        return Mono.create(sink -> this.client.getDataset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ImportPreAnnotatedDataResponse> importPreAnnotatedData(ImportPreAnnotatedDataRequest request) {
        return Mono.create(sink -> this.client.importPreAnnotatedData(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAnnotationFormatsResponse> listAnnotationFormats(ListAnnotationFormatsRequest request) {
        return Mono.create(sink -> this.client.listAnnotationFormats(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDatasetsResponse> listDatasets(ListDatasetsRequest request) {
        return Mono.create(sink -> this.client.listDatasets(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveDatasetLabelsResponse> removeDatasetLabels(RemoveDatasetLabelsRequest request) {
        return Mono.create(sink -> this.client.removeDatasetLabels(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RenameDatasetLabelsResponse> renameDatasetLabels(RenameDatasetLabelsRequest request) {
        return Mono.create(sink -> this.client.renameDatasetLabels(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SnapshotDatasetResponse> snapshotDataset(SnapshotDatasetRequest request) {
        return Mono.create(sink -> this.client.snapshotDataset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDatasetResponse> updateDataset(UpdateDatasetRequest request) {
        return Mono.create(sink -> this.client.updateDataset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

