/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.dashboardservice;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dashboardservice.DashboardAsyncClient;
import com.oracle.bmc.dashboardservice.requests.ChangeDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.CreateDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.DeleteDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.GetDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.ListDashboardsRequest;
import com.oracle.bmc.dashboardservice.requests.UpdateDashboardRequest;
import com.oracle.bmc.dashboardservice.responses.ChangeDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.CreateDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.DeleteDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.GetDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.ListDashboardsResponse;
import com.oracle.bmc.dashboardservice.responses.UpdateDashboardResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DashboardAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DashboardReactorClient {
    DashboardAsyncClient client;

    DashboardReactorClient(DashboardAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeDashboardGroupResponse> changeDashboardGroup(ChangeDashboardGroupRequest request) {
        return Mono.create(sink -> this.client.changeDashboardGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDashboardResponse> createDashboard(CreateDashboardRequest request) {
        return Mono.create(sink -> this.client.createDashboard(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest request) {
        return Mono.create(sink -> this.client.deleteDashboard(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDashboardResponse> getDashboard(GetDashboardRequest request) {
        return Mono.create(sink -> this.client.getDashboard(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDashboardsResponse> listDashboards(ListDashboardsRequest request) {
        return Mono.create(sink -> this.client.listDashboards(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest request) {
        return Mono.create(sink -> this.client.updateDashboard(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

