/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.dashboardservice;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dashboardservice.DashboardGroupAsyncClient;
import com.oracle.bmc.dashboardservice.requests.ChangeDashboardGroupCompartmentRequest;
import com.oracle.bmc.dashboardservice.requests.CreateDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.DeleteDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.GetDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.ListDashboardGroupsRequest;
import com.oracle.bmc.dashboardservice.requests.UpdateDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.responses.ChangeDashboardGroupCompartmentResponse;
import com.oracle.bmc.dashboardservice.responses.CreateDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.DeleteDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.GetDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.ListDashboardGroupsResponse;
import com.oracle.bmc.dashboardservice.responses.UpdateDashboardGroupResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DashboardGroupAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DashboardGroupReactorClient {
    DashboardGroupAsyncClient client;

    DashboardGroupReactorClient(DashboardGroupAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeDashboardGroupCompartmentResponse> changeDashboardGroupCompartment(ChangeDashboardGroupCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeDashboardGroupCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDashboardGroupResponse> createDashboardGroup(CreateDashboardGroupRequest request) {
        return Mono.create(sink -> this.client.createDashboardGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDashboardGroupResponse> deleteDashboardGroup(DeleteDashboardGroupRequest request) {
        return Mono.create(sink -> this.client.deleteDashboardGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDashboardGroupResponse> getDashboardGroup(GetDashboardGroupRequest request) {
        return Mono.create(sink -> this.client.getDashboardGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDashboardGroupsResponse> listDashboardGroups(ListDashboardGroupsRequest request) {
        return Mono.create(sink -> this.client.listDashboardGroups(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDashboardGroupResponse> updateDashboardGroup(UpdateDashboardGroupRequest request) {
        return Mono.create(sink -> this.client.updateDashboardGroup(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

