/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.cloudmigrations;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudmigrations.MigrationAsyncClient;
import com.oracle.bmc.cloudmigrations.requests.CancelWorkRequestRequest;
import com.oracle.bmc.cloudmigrations.requests.ChangeMigrationCompartmentRequest;
import com.oracle.bmc.cloudmigrations.requests.ChangeMigrationPlanCompartmentRequest;
import com.oracle.bmc.cloudmigrations.requests.ChangeReplicationScheduleCompartmentRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.CreateTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.DeleteTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.ExecuteMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.ExportMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.GetMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.GetReplicationProgressRequest;
import com.oracle.bmc.cloudmigrations.requests.GetReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.GetTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudmigrations.requests.ImportMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.ListAvailableShapesRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationAssetsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationPlansRequest;
import com.oracle.bmc.cloudmigrations.requests.ListMigrationsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListReplicationSchedulesRequest;
import com.oracle.bmc.cloudmigrations.requests.ListTargetAssetsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.cloudmigrations.requests.ListWorkRequestsRequest;
import com.oracle.bmc.cloudmigrations.requests.RefreshMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.RefreshMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.RefreshMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.StartAssetReplicationRequest;
import com.oracle.bmc.cloudmigrations.requests.StartMigrationReplicationRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateMigrationAssetRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateMigrationPlanRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateMigrationRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateReplicationScheduleRequest;
import com.oracle.bmc.cloudmigrations.requests.UpdateTargetAssetRequest;
import com.oracle.bmc.cloudmigrations.responses.CancelWorkRequestResponse;
import com.oracle.bmc.cloudmigrations.responses.ChangeMigrationCompartmentResponse;
import com.oracle.bmc.cloudmigrations.responses.ChangeMigrationPlanCompartmentResponse;
import com.oracle.bmc.cloudmigrations.responses.ChangeReplicationScheduleCompartmentResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.CreateTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.DeleteTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.ExecuteMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.ExportMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.GetMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.GetReplicationProgressResponse;
import com.oracle.bmc.cloudmigrations.responses.GetReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.GetTargetAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.GetWorkRequestResponse;
import com.oracle.bmc.cloudmigrations.responses.ImportMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.ListAvailableShapesResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationAssetsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationPlansResponse;
import com.oracle.bmc.cloudmigrations.responses.ListMigrationsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListReplicationSchedulesResponse;
import com.oracle.bmc.cloudmigrations.responses.ListTargetAssetsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.cloudmigrations.responses.ListWorkRequestsResponse;
import com.oracle.bmc.cloudmigrations.responses.RefreshMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.RefreshMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.RefreshMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.StartAssetReplicationResponse;
import com.oracle.bmc.cloudmigrations.responses.StartMigrationReplicationResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateMigrationAssetResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateMigrationPlanResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateMigrationResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateReplicationScheduleResponse;
import com.oracle.bmc.cloudmigrations.responses.UpdateTargetAssetResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={MigrationAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MigrationReactorClient {
    MigrationAsyncClient client;

    MigrationReactorClient(MigrationAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeMigrationCompartmentResponse> changeMigrationCompartment(ChangeMigrationCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeMigrationCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeMigrationPlanCompartmentResponse> changeMigrationPlanCompartment(ChangeMigrationPlanCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeMigrationPlanCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeReplicationScheduleCompartmentResponse> changeReplicationScheduleCompartment(ChangeReplicationScheduleCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeReplicationScheduleCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateMigrationResponse> createMigration(CreateMigrationRequest request) {
        return Mono.create(sink -> this.client.createMigration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateMigrationAssetResponse> createMigrationAsset(CreateMigrationAssetRequest request) {
        return Mono.create(sink -> this.client.createMigrationAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateMigrationPlanResponse> createMigrationPlan(CreateMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.createMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateReplicationScheduleResponse> createReplicationSchedule(CreateReplicationScheduleRequest request) {
        return Mono.create(sink -> this.client.createReplicationSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateTargetAssetResponse> createTargetAsset(CreateTargetAssetRequest request) {
        return Mono.create(sink -> this.client.createTargetAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteMigrationResponse> deleteMigration(DeleteMigrationRequest request) {
        return Mono.create(sink -> this.client.deleteMigration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteMigrationAssetResponse> deleteMigrationAsset(DeleteMigrationAssetRequest request) {
        return Mono.create(sink -> this.client.deleteMigrationAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteMigrationPlanResponse> deleteMigrationPlan(DeleteMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.deleteMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteReplicationScheduleResponse> deleteReplicationSchedule(DeleteReplicationScheduleRequest request) {
        return Mono.create(sink -> this.client.deleteReplicationSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteTargetAssetResponse> deleteTargetAsset(DeleteTargetAssetRequest request) {
        return Mono.create(sink -> this.client.deleteTargetAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ExecuteMigrationPlanResponse> executeMigrationPlan(ExecuteMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.executeMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ExportMigrationPlanResponse> exportMigrationPlan(ExportMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.exportMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMigrationResponse> getMigration(GetMigrationRequest request) {
        return Mono.create(sink -> this.client.getMigration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMigrationAssetResponse> getMigrationAsset(GetMigrationAssetRequest request) {
        return Mono.create(sink -> this.client.getMigrationAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetMigrationPlanResponse> getMigrationPlan(GetMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.getMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetReplicationProgressResponse> getReplicationProgress(GetReplicationProgressRequest request) {
        return Mono.create(sink -> this.client.getReplicationProgress(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetReplicationScheduleResponse> getReplicationSchedule(GetReplicationScheduleRequest request) {
        return Mono.create(sink -> this.client.getReplicationSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetTargetAssetResponse> getTargetAsset(GetTargetAssetRequest request) {
        return Mono.create(sink -> this.client.getTargetAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ImportMigrationPlanResponse> importMigrationPlan(ImportMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.importMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAvailableShapesResponse> listAvailableShapes(ListAvailableShapesRequest request) {
        return Mono.create(sink -> this.client.listAvailableShapes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMigrationAssetsResponse> listMigrationAssets(ListMigrationAssetsRequest request) {
        return Mono.create(sink -> this.client.listMigrationAssets(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMigrationPlansResponse> listMigrationPlans(ListMigrationPlansRequest request) {
        return Mono.create(sink -> this.client.listMigrationPlans(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListMigrationsResponse> listMigrations(ListMigrationsRequest request) {
        return Mono.create(sink -> this.client.listMigrations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListReplicationSchedulesResponse> listReplicationSchedules(ListReplicationSchedulesRequest request) {
        return Mono.create(sink -> this.client.listReplicationSchedules(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListTargetAssetsResponse> listTargetAssets(ListTargetAssetsRequest request) {
        return Mono.create(sink -> this.client.listTargetAssets(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RefreshMigrationResponse> refreshMigration(RefreshMigrationRequest request) {
        return Mono.create(sink -> this.client.refreshMigration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RefreshMigrationAssetResponse> refreshMigrationAsset(RefreshMigrationAssetRequest request) {
        return Mono.create(sink -> this.client.refreshMigrationAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RefreshMigrationPlanResponse> refreshMigrationPlan(RefreshMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.refreshMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartAssetReplicationResponse> startAssetReplication(StartAssetReplicationRequest request) {
        return Mono.create(sink -> this.client.startAssetReplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartMigrationReplicationResponse> startMigrationReplication(StartMigrationReplicationRequest request) {
        return Mono.create(sink -> this.client.startMigrationReplication(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateMigrationResponse> updateMigration(UpdateMigrationRequest request) {
        return Mono.create(sink -> this.client.updateMigration(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateMigrationAssetResponse> updateMigrationAsset(UpdateMigrationAssetRequest request) {
        return Mono.create(sink -> this.client.updateMigrationAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateMigrationPlanResponse> updateMigrationPlan(UpdateMigrationPlanRequest request) {
        return Mono.create(sink -> this.client.updateMigrationPlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateReplicationScheduleResponse> updateReplicationSchedule(UpdateReplicationScheduleRequest request) {
        return Mono.create(sink -> this.client.updateReplicationSchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateTargetAssetResponse> updateTargetAsset(UpdateTargetAssetRequest request) {
        return Mono.create(sink -> this.client.updateTargetAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

