/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.cloudbridge;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.OcbAgentSvcAsyncClient;
import com.oracle.bmc.cloudbridge.requests.AddAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAgentCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAgentDependencyCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeEnvironmentCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAgentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAgentRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.GetAgentRequest;
import com.oracle.bmc.cloudbridge.requests.GetEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.GetPluginRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentDependenciesRequest;
import com.oracle.bmc.cloudbridge.requests.ListAgentsRequest;
import com.oracle.bmc.cloudbridge.requests.ListApplianceImagesRequest;
import com.oracle.bmc.cloudbridge.requests.ListEnvironmentsRequest;
import com.oracle.bmc.cloudbridge.requests.RemoveAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAgentDependencyRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAgentRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateEnvironmentRequest;
import com.oracle.bmc.cloudbridge.requests.UpdatePluginRequest;
import com.oracle.bmc.cloudbridge.responses.AddAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAgentCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAgentDependencyCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeEnvironmentCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAgentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAgentResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.GetAgentResponse;
import com.oracle.bmc.cloudbridge.responses.GetEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.GetPluginResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentDependenciesResponse;
import com.oracle.bmc.cloudbridge.responses.ListAgentsResponse;
import com.oracle.bmc.cloudbridge.responses.ListApplianceImagesResponse;
import com.oracle.bmc.cloudbridge.responses.ListEnvironmentsResponse;
import com.oracle.bmc.cloudbridge.responses.RemoveAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAgentDependencyResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAgentResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateEnvironmentResponse;
import com.oracle.bmc.cloudbridge.responses.UpdatePluginResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={OcbAgentSvcAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OcbAgentSvcReactorClient {
    OcbAgentSvcAsyncClient client;

    OcbAgentSvcReactorClient(OcbAgentSvcAsyncClient client) {
        this.client = client;
    }

    public Mono<AddAgentDependencyResponse> addAgentDependency(AddAgentDependencyRequest request) {
        return Mono.create(sink -> this.client.addAgentDependency(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAgentCompartmentResponse> changeAgentCompartment(ChangeAgentCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAgentCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAgentDependencyCompartmentResponse> changeAgentDependencyCompartment(ChangeAgentDependencyCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAgentDependencyCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeEnvironmentCompartmentResponse> changeEnvironmentCompartment(ChangeEnvironmentCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeEnvironmentCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAgentResponse> createAgent(CreateAgentRequest request) {
        return Mono.create(sink -> this.client.createAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAgentDependencyResponse> createAgentDependency(CreateAgentDependencyRequest request) {
        return Mono.create(sink -> this.client.createAgentDependency(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateEnvironmentResponse> createEnvironment(CreateEnvironmentRequest request) {
        return Mono.create(sink -> this.client.createEnvironment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAgentResponse> deleteAgent(DeleteAgentRequest request) {
        return Mono.create(sink -> this.client.deleteAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAgentDependencyResponse> deleteAgentDependency(DeleteAgentDependencyRequest request) {
        return Mono.create(sink -> this.client.deleteAgentDependency(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest request) {
        return Mono.create(sink -> this.client.deleteEnvironment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAgentResponse> getAgent(GetAgentRequest request) {
        return Mono.create(sink -> this.client.getAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAgentDependencyResponse> getAgentDependency(GetAgentDependencyRequest request) {
        return Mono.create(sink -> this.client.getAgentDependency(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetEnvironmentResponse> getEnvironment(GetEnvironmentRequest request) {
        return Mono.create(sink -> this.client.getEnvironment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPluginResponse> getPlugin(GetPluginRequest request) {
        return Mono.create(sink -> this.client.getPlugin(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAgentDependenciesResponse> listAgentDependencies(ListAgentDependenciesRequest request) {
        return Mono.create(sink -> this.client.listAgentDependencies(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAgentsResponse> listAgents(ListAgentsRequest request) {
        return Mono.create(sink -> this.client.listAgents(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListApplianceImagesResponse> listApplianceImages(ListApplianceImagesRequest request) {
        return Mono.create(sink -> this.client.listApplianceImages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest request) {
        return Mono.create(sink -> this.client.listEnvironments(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveAgentDependencyResponse> removeAgentDependency(RemoveAgentDependencyRequest request) {
        return Mono.create(sink -> this.client.removeAgentDependency(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAgentResponse> updateAgent(UpdateAgentRequest request) {
        return Mono.create(sink -> this.client.updateAgent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAgentDependencyResponse> updateAgentDependency(UpdateAgentDependencyRequest request) {
        return Mono.create(sink -> this.client.updateAgentDependency(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest request) {
        return Mono.create(sink -> this.client.updateEnvironment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdatePluginResponse> updatePlugin(UpdatePluginRequest request) {
        return Mono.create(sink -> this.client.updatePlugin(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

