/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.cloudbridge;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.CommonAsyncClient;
import com.oracle.bmc.cloudbridge.requests.CancelWorkRequestRequest;
import com.oracle.bmc.cloudbridge.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudbridge.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.cloudbridge.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.cloudbridge.requests.ListWorkRequestsRequest;
import com.oracle.bmc.cloudbridge.responses.CancelWorkRequestResponse;
import com.oracle.bmc.cloudbridge.responses.GetWorkRequestResponse;
import com.oracle.bmc.cloudbridge.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.cloudbridge.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.cloudbridge.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={CommonAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class CommonRxClient {
    CommonAsyncClient client;

    CommonRxClient(CommonAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

