/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.cloudbridge;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.InventoryAsyncClient;
import com.oracle.bmc.cloudbridge.requests.AnalyzeAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetTagsRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.CreateInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetRequest;
import com.oracle.bmc.cloudbridge.requests.GetInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ImportInventoryRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetsRequest;
import com.oracle.bmc.cloudbridge.requests.ListHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.ListInventoriesRequest;
import com.oracle.bmc.cloudbridge.requests.SubmitHistoricalMetricsRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateInventoryRequest;
import com.oracle.bmc.cloudbridge.responses.AnalyzeAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetTagsResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.CreateInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetResponse;
import com.oracle.bmc.cloudbridge.responses.GetInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ImportInventoryResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetsResponse;
import com.oracle.bmc.cloudbridge.responses.ListHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.ListInventoriesResponse;
import com.oracle.bmc.cloudbridge.responses.SubmitHistoricalMetricsResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateInventoryResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={InventoryAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class InventoryReactorClient {
    InventoryAsyncClient client;

    InventoryReactorClient(InventoryAsyncClient client) {
        this.client = client;
    }

    public Mono<AnalyzeAssetsResponse> analyzeAssets(AnalyzeAssetsRequest request) {
        return Mono.create(sink -> this.client.analyzeAssets(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAssetCompartmentResponse> changeAssetCompartment(ChangeAssetCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAssetCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAssetTagsResponse> changeAssetTags(ChangeAssetTagsRequest request) {
        return Mono.create(sink -> this.client.changeAssetTags(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAssetResponse> createAsset(CreateAssetRequest request) {
        return Mono.create(sink -> this.client.createAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateInventoryResponse> createInventory(CreateInventoryRequest request) {
        return Mono.create(sink -> this.client.createInventory(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAssetResponse> deleteAsset(DeleteAssetRequest request) {
        return Mono.create(sink -> this.client.deleteAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteInventoryResponse> deleteInventory(DeleteInventoryRequest request) {
        return Mono.create(sink -> this.client.deleteInventory(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAssetResponse> getAsset(GetAssetRequest request) {
        return Mono.create(sink -> this.client.getAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetInventoryResponse> getInventory(GetInventoryRequest request) {
        return Mono.create(sink -> this.client.getInventory(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ImportInventoryResponse> importInventory(ImportInventoryRequest request) {
        return Mono.create(sink -> this.client.importInventory(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAssetsResponse> listAssets(ListAssetsRequest request) {
        return Mono.create(sink -> this.client.listAssets(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListHistoricalMetricsResponse> listHistoricalMetrics(ListHistoricalMetricsRequest request) {
        return Mono.create(sink -> this.client.listHistoricalMetrics(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListInventoriesResponse> listInventories(ListInventoriesRequest request) {
        return Mono.create(sink -> this.client.listInventories(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SubmitHistoricalMetricsResponse> submitHistoricalMetrics(SubmitHistoricalMetricsRequest request) {
        return Mono.create(sink -> this.client.submitHistoricalMetrics(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAssetResponse> updateAsset(UpdateAssetRequest request) {
        return Mono.create(sink -> this.client.updateAsset(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateInventoryResponse> updateInventory(UpdateInventoryRequest request) {
        return Mono.create(sink -> this.client.updateInventory(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

