/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.cloudbridge;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.DiscoveryAsyncClient;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetSourceCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeDiscoveryScheduleCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.CreateDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.GetDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourceConnectionsRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourcesRequest;
import com.oracle.bmc.cloudbridge.requests.ListDiscoverySchedulesRequest;
import com.oracle.bmc.cloudbridge.requests.ListSupportedCloudRegionsRequest;
import com.oracle.bmc.cloudbridge.requests.RefreshAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetSourceCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeDiscoveryScheduleCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.CreateDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.GetDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourceConnectionsResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourcesResponse;
import com.oracle.bmc.cloudbridge.responses.ListDiscoverySchedulesResponse;
import com.oracle.bmc.cloudbridge.responses.ListSupportedCloudRegionsResponse;
import com.oracle.bmc.cloudbridge.responses.RefreshAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateDiscoveryScheduleResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DiscoveryAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DiscoveryReactorClient {
    DiscoveryAsyncClient client;

    DiscoveryReactorClient(DiscoveryAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeAssetSourceCompartmentResponse> changeAssetSourceCompartment(ChangeAssetSourceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAssetSourceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeDiscoveryScheduleCompartmentResponse> changeDiscoveryScheduleCompartment(ChangeDiscoveryScheduleCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeDiscoveryScheduleCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAssetSourceResponse> createAssetSource(CreateAssetSourceRequest request) {
        return Mono.create(sink -> this.client.createAssetSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDiscoveryScheduleResponse> createDiscoverySchedule(CreateDiscoveryScheduleRequest request) {
        return Mono.create(sink -> this.client.createDiscoverySchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAssetSourceResponse> deleteAssetSource(DeleteAssetSourceRequest request) {
        return Mono.create(sink -> this.client.deleteAssetSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDiscoveryScheduleResponse> deleteDiscoverySchedule(DeleteDiscoveryScheduleRequest request) {
        return Mono.create(sink -> this.client.deleteDiscoverySchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAssetSourceResponse> getAssetSource(GetAssetSourceRequest request) {
        return Mono.create(sink -> this.client.getAssetSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDiscoveryScheduleResponse> getDiscoverySchedule(GetDiscoveryScheduleRequest request) {
        return Mono.create(sink -> this.client.getDiscoverySchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAssetSourceConnectionsResponse> listAssetSourceConnections(ListAssetSourceConnectionsRequest request) {
        return Mono.create(sink -> this.client.listAssetSourceConnections(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAssetSourcesResponse> listAssetSources(ListAssetSourcesRequest request) {
        return Mono.create(sink -> this.client.listAssetSources(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDiscoverySchedulesResponse> listDiscoverySchedules(ListDiscoverySchedulesRequest request) {
        return Mono.create(sink -> this.client.listDiscoverySchedules(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSupportedCloudRegionsResponse> listSupportedCloudRegions(ListSupportedCloudRegionsRequest request) {
        return Mono.create(sink -> this.client.listSupportedCloudRegions(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RefreshAssetSourceResponse> refreshAssetSource(RefreshAssetSourceRequest request) {
        return Mono.create(sink -> this.client.refreshAssetSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAssetSourceResponse> updateAssetSource(UpdateAssetSourceRequest request) {
        return Mono.create(sink -> this.client.updateAssetSource(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDiscoveryScheduleResponse> updateDiscoverySchedule(UpdateDiscoveryScheduleRequest request) {
        return Mono.create(sink -> this.client.updateDiscoverySchedule(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

