/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.cloudbridge;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.CommonAsyncClient;
import com.oracle.bmc.cloudbridge.requests.CancelWorkRequestRequest;
import com.oracle.bmc.cloudbridge.requests.GetWorkRequestRequest;
import com.oracle.bmc.cloudbridge.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.cloudbridge.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.cloudbridge.requests.ListWorkRequestsRequest;
import com.oracle.bmc.cloudbridge.responses.CancelWorkRequestResponse;
import com.oracle.bmc.cloudbridge.responses.GetWorkRequestResponse;
import com.oracle.bmc.cloudbridge.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.cloudbridge.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.cloudbridge.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={CommonAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class CommonReactorClient {
    CommonAsyncClient client;

    CommonReactorClient(CommonAsyncClient client) {
        this.client = client;
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

