/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apigateway;

import com.oracle.bmc.apigateway.SubscribersAsyncClient;
import com.oracle.bmc.apigateway.requests.AddSubscriberLockRequest;
import com.oracle.bmc.apigateway.requests.ChangeSubscriberCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateSubscriberRequest;
import com.oracle.bmc.apigateway.requests.DeleteSubscriberRequest;
import com.oracle.bmc.apigateway.requests.GetSubscriberRequest;
import com.oracle.bmc.apigateway.requests.ListSubscribersRequest;
import com.oracle.bmc.apigateway.requests.RemoveSubscriberLockRequest;
import com.oracle.bmc.apigateway.requests.UpdateSubscriberRequest;
import com.oracle.bmc.apigateway.responses.AddSubscriberLockResponse;
import com.oracle.bmc.apigateway.responses.ChangeSubscriberCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateSubscriberResponse;
import com.oracle.bmc.apigateway.responses.DeleteSubscriberResponse;
import com.oracle.bmc.apigateway.responses.GetSubscriberResponse;
import com.oracle.bmc.apigateway.responses.ListSubscribersResponse;
import com.oracle.bmc.apigateway.responses.RemoveSubscriberLockResponse;
import com.oracle.bmc.apigateway.responses.UpdateSubscriberResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={SubscribersAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SubscribersRxClient {
    SubscribersAsyncClient client;

    SubscribersRxClient(SubscribersAsyncClient client) {
        this.client = client;
    }

    public Single<AddSubscriberLockResponse> addSubscriberLock(AddSubscriberLockRequest request) {
        return Single.create(emitter -> this.client.addSubscriberLock(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeSubscriberCompartmentResponse> changeSubscriberCompartment(ChangeSubscriberCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeSubscriberCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest request) {
        return Single.create(emitter -> this.client.createSubscriber(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest request) {
        return Single.create(emitter -> this.client.deleteSubscriber(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSubscriberResponse> getSubscriber(GetSubscriberRequest request) {
        return Single.create(emitter -> this.client.getSubscriber(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscribersResponse> listSubscribers(ListSubscribersRequest request) {
        return Single.create(emitter -> this.client.listSubscribers(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveSubscriberLockResponse> removeSubscriberLock(RemoveSubscriberLockRequest request) {
        return Single.create(emitter -> this.client.removeSubscriberLock(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest request) {
        return Single.create(emitter -> this.client.updateSubscriber(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

