/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apigateway;

import com.oracle.bmc.apigateway.UsagePlansAsyncClient;
import com.oracle.bmc.apigateway.requests.AddUsagePlanLockRequest;
import com.oracle.bmc.apigateway.requests.ChangeUsagePlanCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.DeleteUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.GetUsagePlanRequest;
import com.oracle.bmc.apigateway.requests.ListUsagePlansRequest;
import com.oracle.bmc.apigateway.requests.RemoveUsagePlanLockRequest;
import com.oracle.bmc.apigateway.requests.UpdateUsagePlanRequest;
import com.oracle.bmc.apigateway.responses.AddUsagePlanLockResponse;
import com.oracle.bmc.apigateway.responses.ChangeUsagePlanCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.DeleteUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.GetUsagePlanResponse;
import com.oracle.bmc.apigateway.responses.ListUsagePlansResponse;
import com.oracle.bmc.apigateway.responses.RemoveUsagePlanLockResponse;
import com.oracle.bmc.apigateway.responses.UpdateUsagePlanResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={UsagePlansAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class UsagePlansReactorClient {
    UsagePlansAsyncClient client;

    UsagePlansReactorClient(UsagePlansAsyncClient client) {
        this.client = client;
    }

    public Mono<AddUsagePlanLockResponse> addUsagePlanLock(AddUsagePlanLockRequest request) {
        return Mono.create(sink -> this.client.addUsagePlanLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeUsagePlanCompartmentResponse> changeUsagePlanCompartment(ChangeUsagePlanCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeUsagePlanCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateUsagePlanResponse> createUsagePlan(CreateUsagePlanRequest request) {
        return Mono.create(sink -> this.client.createUsagePlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteUsagePlanResponse> deleteUsagePlan(DeleteUsagePlanRequest request) {
        return Mono.create(sink -> this.client.deleteUsagePlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetUsagePlanResponse> getUsagePlan(GetUsagePlanRequest request) {
        return Mono.create(sink -> this.client.getUsagePlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListUsagePlansResponse> listUsagePlans(ListUsagePlansRequest request) {
        return Mono.create(sink -> this.client.listUsagePlans(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveUsagePlanLockResponse> removeUsagePlanLock(RemoveUsagePlanLockRequest request) {
        return Mono.create(sink -> this.client.removeUsagePlanLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateUsagePlanResponse> updateUsagePlan(UpdateUsagePlanRequest request) {
        return Mono.create(sink -> this.client.updateUsagePlan(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

