/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apigateway;

import com.oracle.bmc.apigateway.SubscribersAsyncClient;
import com.oracle.bmc.apigateway.requests.AddSubscriberLockRequest;
import com.oracle.bmc.apigateway.requests.ChangeSubscriberCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateSubscriberRequest;
import com.oracle.bmc.apigateway.requests.DeleteSubscriberRequest;
import com.oracle.bmc.apigateway.requests.GetSubscriberRequest;
import com.oracle.bmc.apigateway.requests.ListSubscribersRequest;
import com.oracle.bmc.apigateway.requests.RemoveSubscriberLockRequest;
import com.oracle.bmc.apigateway.requests.UpdateSubscriberRequest;
import com.oracle.bmc.apigateway.responses.AddSubscriberLockResponse;
import com.oracle.bmc.apigateway.responses.ChangeSubscriberCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateSubscriberResponse;
import com.oracle.bmc.apigateway.responses.DeleteSubscriberResponse;
import com.oracle.bmc.apigateway.responses.GetSubscriberResponse;
import com.oracle.bmc.apigateway.responses.ListSubscribersResponse;
import com.oracle.bmc.apigateway.responses.RemoveSubscriberLockResponse;
import com.oracle.bmc.apigateway.responses.UpdateSubscriberResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={SubscribersAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SubscribersReactorClient {
    SubscribersAsyncClient client;

    SubscribersReactorClient(SubscribersAsyncClient client) {
        this.client = client;
    }

    public Mono<AddSubscriberLockResponse> addSubscriberLock(AddSubscriberLockRequest request) {
        return Mono.create(sink -> this.client.addSubscriberLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeSubscriberCompartmentResponse> changeSubscriberCompartment(ChangeSubscriberCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeSubscriberCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest request) {
        return Mono.create(sink -> this.client.createSubscriber(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest request) {
        return Mono.create(sink -> this.client.deleteSubscriber(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSubscriberResponse> getSubscriber(GetSubscriberRequest request) {
        return Mono.create(sink -> this.client.getSubscriber(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSubscribersResponse> listSubscribers(ListSubscribersRequest request) {
        return Mono.create(sink -> this.client.listSubscribers(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveSubscriberLockResponse> removeSubscriberLock(RemoveSubscriberLockRequest request) {
        return Mono.create(sink -> this.client.removeSubscriberLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest request) {
        return Mono.create(sink -> this.client.updateSubscriber(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

