/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apigateway;

import com.oracle.bmc.apigateway.DeploymentAsyncClient;
import com.oracle.bmc.apigateway.requests.AddDeploymentLockRequest;
import com.oracle.bmc.apigateway.requests.ChangeDeploymentCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateDeploymentRequest;
import com.oracle.bmc.apigateway.requests.DeleteDeploymentRequest;
import com.oracle.bmc.apigateway.requests.GetDeploymentRequest;
import com.oracle.bmc.apigateway.requests.ListDeploymentsRequest;
import com.oracle.bmc.apigateway.requests.RemoveDeploymentLockRequest;
import com.oracle.bmc.apigateway.requests.UpdateDeploymentRequest;
import com.oracle.bmc.apigateway.responses.AddDeploymentLockResponse;
import com.oracle.bmc.apigateway.responses.ChangeDeploymentCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateDeploymentResponse;
import com.oracle.bmc.apigateway.responses.DeleteDeploymentResponse;
import com.oracle.bmc.apigateway.responses.GetDeploymentResponse;
import com.oracle.bmc.apigateway.responses.ListDeploymentsResponse;
import com.oracle.bmc.apigateway.responses.RemoveDeploymentLockResponse;
import com.oracle.bmc.apigateway.responses.UpdateDeploymentResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={DeploymentAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DeploymentReactorClient {
    DeploymentAsyncClient client;

    DeploymentReactorClient(DeploymentAsyncClient client) {
        this.client = client;
    }

    public Mono<AddDeploymentLockResponse> addDeploymentLock(AddDeploymentLockRequest request) {
        return Mono.create(sink -> this.client.addDeploymentLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeDeploymentCompartmentResponse> changeDeploymentCompartment(ChangeDeploymentCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeDeploymentCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest request) {
        return Mono.create(sink -> this.client.createDeployment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteDeploymentResponse> deleteDeployment(DeleteDeploymentRequest request) {
        return Mono.create(sink -> this.client.deleteDeployment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetDeploymentResponse> getDeployment(GetDeploymentRequest request) {
        return Mono.create(sink -> this.client.getDeployment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest request) {
        return Mono.create(sink -> this.client.listDeployments(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveDeploymentLockResponse> removeDeploymentLock(RemoveDeploymentLockRequest request) {
        return Mono.create(sink -> this.client.removeDeploymentLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest request) {
        return Mono.create(sink -> this.client.updateDeployment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

