/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apigateway;

import com.oracle.bmc.apigateway.ApiGatewayAsyncClient;
import com.oracle.bmc.apigateway.requests.AddApiLockRequest;
import com.oracle.bmc.apigateway.requests.AddCertificateLockRequest;
import com.oracle.bmc.apigateway.requests.AddSdkLockRequest;
import com.oracle.bmc.apigateway.requests.ChangeApiCompartmentRequest;
import com.oracle.bmc.apigateway.requests.ChangeCertificateCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateApiRequest;
import com.oracle.bmc.apigateway.requests.CreateCertificateRequest;
import com.oracle.bmc.apigateway.requests.CreateSdkRequest;
import com.oracle.bmc.apigateway.requests.DeleteApiRequest;
import com.oracle.bmc.apigateway.requests.DeleteCertificateRequest;
import com.oracle.bmc.apigateway.requests.DeleteSdkRequest;
import com.oracle.bmc.apigateway.requests.GetApiContentRequest;
import com.oracle.bmc.apigateway.requests.GetApiDeploymentSpecificationRequest;
import com.oracle.bmc.apigateway.requests.GetApiRequest;
import com.oracle.bmc.apigateway.requests.GetApiValidationsRequest;
import com.oracle.bmc.apigateway.requests.GetCertificateRequest;
import com.oracle.bmc.apigateway.requests.GetSdkRequest;
import com.oracle.bmc.apigateway.requests.ListApisRequest;
import com.oracle.bmc.apigateway.requests.ListCertificatesRequest;
import com.oracle.bmc.apigateway.requests.ListSdkLanguageTypesRequest;
import com.oracle.bmc.apigateway.requests.ListSdksRequest;
import com.oracle.bmc.apigateway.requests.RemoveApiLockRequest;
import com.oracle.bmc.apigateway.requests.RemoveCertificateLockRequest;
import com.oracle.bmc.apigateway.requests.RemoveSdkLockRequest;
import com.oracle.bmc.apigateway.requests.UpdateApiRequest;
import com.oracle.bmc.apigateway.requests.UpdateCertificateRequest;
import com.oracle.bmc.apigateway.requests.UpdateSdkRequest;
import com.oracle.bmc.apigateway.responses.AddApiLockResponse;
import com.oracle.bmc.apigateway.responses.AddCertificateLockResponse;
import com.oracle.bmc.apigateway.responses.AddSdkLockResponse;
import com.oracle.bmc.apigateway.responses.ChangeApiCompartmentResponse;
import com.oracle.bmc.apigateway.responses.ChangeCertificateCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateApiResponse;
import com.oracle.bmc.apigateway.responses.CreateCertificateResponse;
import com.oracle.bmc.apigateway.responses.CreateSdkResponse;
import com.oracle.bmc.apigateway.responses.DeleteApiResponse;
import com.oracle.bmc.apigateway.responses.DeleteCertificateResponse;
import com.oracle.bmc.apigateway.responses.DeleteSdkResponse;
import com.oracle.bmc.apigateway.responses.GetApiContentResponse;
import com.oracle.bmc.apigateway.responses.GetApiDeploymentSpecificationResponse;
import com.oracle.bmc.apigateway.responses.GetApiResponse;
import com.oracle.bmc.apigateway.responses.GetApiValidationsResponse;
import com.oracle.bmc.apigateway.responses.GetCertificateResponse;
import com.oracle.bmc.apigateway.responses.GetSdkResponse;
import com.oracle.bmc.apigateway.responses.ListApisResponse;
import com.oracle.bmc.apigateway.responses.ListCertificatesResponse;
import com.oracle.bmc.apigateway.responses.ListSdkLanguageTypesResponse;
import com.oracle.bmc.apigateway.responses.ListSdksResponse;
import com.oracle.bmc.apigateway.responses.RemoveApiLockResponse;
import com.oracle.bmc.apigateway.responses.RemoveCertificateLockResponse;
import com.oracle.bmc.apigateway.responses.RemoveSdkLockResponse;
import com.oracle.bmc.apigateway.responses.UpdateApiResponse;
import com.oracle.bmc.apigateway.responses.UpdateCertificateResponse;
import com.oracle.bmc.apigateway.responses.UpdateSdkResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ApiGatewayAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ApiGatewayReactorClient {
    ApiGatewayAsyncClient client;

    ApiGatewayReactorClient(ApiGatewayAsyncClient client) {
        this.client = client;
    }

    public Mono<AddApiLockResponse> addApiLock(AddApiLockRequest request) {
        return Mono.create(sink -> this.client.addApiLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<AddCertificateLockResponse> addCertificateLock(AddCertificateLockRequest request) {
        return Mono.create(sink -> this.client.addCertificateLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<AddSdkLockResponse> addSdkLock(AddSdkLockRequest request) {
        return Mono.create(sink -> this.client.addSdkLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeApiCompartmentResponse> changeApiCompartment(ChangeApiCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeApiCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeCertificateCompartmentResponse> changeCertificateCompartment(ChangeCertificateCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeCertificateCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateApiResponse> createApi(CreateApiRequest request) {
        return Mono.create(sink -> this.client.createApi(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateCertificateResponse> createCertificate(CreateCertificateRequest request) {
        return Mono.create(sink -> this.client.createCertificate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateSdkResponse> createSdk(CreateSdkRequest request) {
        return Mono.create(sink -> this.client.createSdk(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteApiResponse> deleteApi(DeleteApiRequest request) {
        return Mono.create(sink -> this.client.deleteApi(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest request) {
        return Mono.create(sink -> this.client.deleteCertificate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteSdkResponse> deleteSdk(DeleteSdkRequest request) {
        return Mono.create(sink -> this.client.deleteSdk(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetApiResponse> getApi(GetApiRequest request) {
        return Mono.create(sink -> this.client.getApi(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetApiContentResponse> getApiContent(GetApiContentRequest request) {
        return Mono.create(sink -> this.client.getApiContent(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetApiDeploymentSpecificationResponse> getApiDeploymentSpecification(GetApiDeploymentSpecificationRequest request) {
        return Mono.create(sink -> this.client.getApiDeploymentSpecification(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetApiValidationsResponse> getApiValidations(GetApiValidationsRequest request) {
        return Mono.create(sink -> this.client.getApiValidations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetCertificateResponse> getCertificate(GetCertificateRequest request) {
        return Mono.create(sink -> this.client.getCertificate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetSdkResponse> getSdk(GetSdkRequest request) {
        return Mono.create(sink -> this.client.getSdk(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListApisResponse> listApis(ListApisRequest request) {
        return Mono.create(sink -> this.client.listApis(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListCertificatesResponse> listCertificates(ListCertificatesRequest request) {
        return Mono.create(sink -> this.client.listCertificates(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSdkLanguageTypesResponse> listSdkLanguageTypes(ListSdkLanguageTypesRequest request) {
        return Mono.create(sink -> this.client.listSdkLanguageTypes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListSdksResponse> listSdks(ListSdksRequest request) {
        return Mono.create(sink -> this.client.listSdks(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveApiLockResponse> removeApiLock(RemoveApiLockRequest request) {
        return Mono.create(sink -> this.client.removeApiLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveCertificateLockResponse> removeCertificateLock(RemoveCertificateLockRequest request) {
        return Mono.create(sink -> this.client.removeCertificateLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<RemoveSdkLockResponse> removeSdkLock(RemoveSdkLockRequest request) {
        return Mono.create(sink -> this.client.removeSdkLock(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateApiResponse> updateApi(UpdateApiRequest request) {
        return Mono.create(sink -> this.client.updateApi(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest request) {
        return Mono.create(sink -> this.client.updateCertificate(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateSdkResponse> updateSdk(UpdateSdkRequest request) {
        return Mono.create(sink -> this.client.updateSdk(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

