/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.apigateway;

import com.oracle.bmc.apigateway.GatewayAsyncClient;
import com.oracle.bmc.apigateway.requests.ChangeGatewayCompartmentRequest;
import com.oracle.bmc.apigateway.requests.CreateGatewayRequest;
import com.oracle.bmc.apigateway.requests.DeleteGatewayRequest;
import com.oracle.bmc.apigateway.requests.GetGatewayRequest;
import com.oracle.bmc.apigateway.requests.ListGatewaysRequest;
import com.oracle.bmc.apigateway.requests.UpdateGatewayRequest;
import com.oracle.bmc.apigateway.responses.ChangeGatewayCompartmentResponse;
import com.oracle.bmc.apigateway.responses.CreateGatewayResponse;
import com.oracle.bmc.apigateway.responses.DeleteGatewayResponse;
import com.oracle.bmc.apigateway.responses.GetGatewayResponse;
import com.oracle.bmc.apigateway.responses.ListGatewaysResponse;
import com.oracle.bmc.apigateway.responses.UpdateGatewayResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={GatewayAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GatewayReactorClient {
    GatewayAsyncClient client;

    GatewayReactorClient(GatewayAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeGatewayCompartmentResponse> changeGatewayCompartment(ChangeGatewayCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeGatewayCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateGatewayResponse> createGateway(CreateGatewayRequest request) {
        return Mono.create(sink -> this.client.createGateway(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest request) {
        return Mono.create(sink -> this.client.deleteGateway(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetGatewayResponse> getGateway(GetGatewayRequest request) {
        return Mono.create(sink -> this.client.getGateway(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListGatewaysResponse> listGateways(ListGatewaysRequest request) {
        return Mono.create(sink -> this.client.listGateways(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest request) {
        return Mono.create(sink -> this.client.updateGateway(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

