/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.analytics;

import com.oracle.bmc.analytics.AnalyticsAsyncClient;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceCompartmentRequest;
import com.oracle.bmc.analytics.requests.ChangeAnalyticsInstanceNetworkEndpointRequest;
import com.oracle.bmc.analytics.requests.CreateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.CreatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.CreateVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.DeletePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.DeleteVanityUrlRequest;
import com.oracle.bmc.analytics.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.analytics.requests.GetAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.GetPrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.analytics.requests.ListAnalyticsInstancesRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.analytics.requests.ListWorkRequestsRequest;
import com.oracle.bmc.analytics.requests.ScaleAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.SetFeatureBundleRequest;
import com.oracle.bmc.analytics.requests.SetKmsKeyRequest;
import com.oracle.bmc.analytics.requests.StartAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.StopAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdateAnalyticsInstanceRequest;
import com.oracle.bmc.analytics.requests.UpdatePrivateAccessChannelRequest;
import com.oracle.bmc.analytics.requests.UpdateVanityUrlRequest;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceCompartmentResponse;
import com.oracle.bmc.analytics.responses.ChangeAnalyticsInstanceNetworkEndpointResponse;
import com.oracle.bmc.analytics.responses.CreateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.CreatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.CreateVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.DeletePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.DeleteVanityUrlResponse;
import com.oracle.bmc.analytics.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.analytics.responses.GetAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.GetPrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.analytics.responses.ListAnalyticsInstancesResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.analytics.responses.ListWorkRequestsResponse;
import com.oracle.bmc.analytics.responses.ScaleAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.SetFeatureBundleResponse;
import com.oracle.bmc.analytics.responses.SetKmsKeyResponse;
import com.oracle.bmc.analytics.responses.StartAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.StopAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdateAnalyticsInstanceResponse;
import com.oracle.bmc.analytics.responses.UpdatePrivateAccessChannelResponse;
import com.oracle.bmc.analytics.responses.UpdateVanityUrlResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={AnalyticsAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AnalyticsReactorClient {
    AnalyticsAsyncClient client;

    AnalyticsReactorClient(AnalyticsAsyncClient client) {
        this.client = client;
    }

    public Mono<ChangeAnalyticsInstanceCompartmentResponse> changeAnalyticsInstanceCompartment(ChangeAnalyticsInstanceCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeAnalyticsInstanceCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeAnalyticsInstanceNetworkEndpointResponse> changeAnalyticsInstanceNetworkEndpoint(ChangeAnalyticsInstanceNetworkEndpointRequest request) {
        return Mono.create(sink -> this.client.changeAnalyticsInstanceNetworkEndpoint(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateAnalyticsInstanceResponse> createAnalyticsInstance(CreateAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.createAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreatePrivateAccessChannelResponse> createPrivateAccessChannel(CreatePrivateAccessChannelRequest request) {
        return Mono.create(sink -> this.client.createPrivateAccessChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateVanityUrlResponse> createVanityUrl(CreateVanityUrlRequest request) {
        return Mono.create(sink -> this.client.createVanityUrl(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteAnalyticsInstanceResponse> deleteAnalyticsInstance(DeleteAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.deleteAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeletePrivateAccessChannelResponse> deletePrivateAccessChannel(DeletePrivateAccessChannelRequest request) {
        return Mono.create(sink -> this.client.deletePrivateAccessChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteVanityUrlResponse> deleteVanityUrl(DeleteVanityUrlRequest request) {
        return Mono.create(sink -> this.client.deleteVanityUrl(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request) {
        return Mono.create(sink -> this.client.deleteWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetAnalyticsInstanceResponse> getAnalyticsInstance(GetAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.getAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetPrivateAccessChannelResponse> getPrivateAccessChannel(GetPrivateAccessChannelRequest request) {
        return Mono.create(sink -> this.client.getPrivateAccessChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListAnalyticsInstancesResponse> listAnalyticsInstances(ListAnalyticsInstancesRequest request) {
        return Mono.create(sink -> this.client.listAnalyticsInstances(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ScaleAnalyticsInstanceResponse> scaleAnalyticsInstance(ScaleAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.scaleAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SetFeatureBundleResponse> setFeatureBundle(SetFeatureBundleRequest request) {
        return Mono.create(sink -> this.client.setFeatureBundle(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<SetKmsKeyResponse> setKmsKey(SetKmsKeyRequest request) {
        return Mono.create(sink -> this.client.setKmsKey(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StartAnalyticsInstanceResponse> startAnalyticsInstance(StartAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.startAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<StopAnalyticsInstanceResponse> stopAnalyticsInstance(StopAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.stopAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateAnalyticsInstanceResponse> updateAnalyticsInstance(UpdateAnalyticsInstanceRequest request) {
        return Mono.create(sink -> this.client.updateAnalyticsInstance(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdatePrivateAccessChannelResponse> updatePrivateAccessChannel(UpdatePrivateAccessChannelRequest request) {
        return Mono.create(sink -> this.client.updatePrivateAccessChannel(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateVanityUrlResponse> updateVanityUrl(UpdateVanityUrlRequest request) {
        return Mono.create(sink -> this.client.updateVanityUrl(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

