/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.reactor.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementAsyncClient;
import com.oracle.bmc.adm.requests.ActivateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.CancelRemediationRunRequest;
import com.oracle.bmc.adm.requests.CancelWorkRequestRequest;
import com.oracle.bmc.adm.requests.ChangeKnowledgeBaseCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeRemediationRecipeCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeRemediationRunCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeVulnerabilityAuditCompartmentRequest;
import com.oracle.bmc.adm.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.CreateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.CreateRemediationRunRequest;
import com.oracle.bmc.adm.requests.CreateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.DeactivateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.DeleteKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.DeleteRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.DeleteRemediationRunRequest;
import com.oracle.bmc.adm.requests.DeleteVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.GetRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.GetRemediationRunRequest;
import com.oracle.bmc.adm.requests.GetStageRequest;
import com.oracle.bmc.adm.requests.GetVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetWorkRequestRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyRecommendationsRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyVulnerabilitiesRequest;
import com.oracle.bmc.adm.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.adm.requests.ListRemediationRecipesRequest;
import com.oracle.bmc.adm.requests.ListRemediationRunsRequest;
import com.oracle.bmc.adm.requests.ListStagesRequest;
import com.oracle.bmc.adm.requests.ListVulnerabilityAuditsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestsRequest;
import com.oracle.bmc.adm.requests.UpdateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.UpdateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.UpdateRemediationRunRequest;
import com.oracle.bmc.adm.requests.UpdateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.responses.ActivateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.CancelRemediationRunResponse;
import com.oracle.bmc.adm.responses.CancelWorkRequestResponse;
import com.oracle.bmc.adm.responses.ChangeKnowledgeBaseCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeRemediationRecipeCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeRemediationRunCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeVulnerabilityAuditCompartmentResponse;
import com.oracle.bmc.adm.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.CreateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.CreateRemediationRunResponse;
import com.oracle.bmc.adm.responses.CreateVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.DeactivateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.DeleteKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.DeleteRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.DeleteRemediationRunResponse;
import com.oracle.bmc.adm.responses.DeleteVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.GetRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.GetRemediationRunResponse;
import com.oracle.bmc.adm.responses.GetStageResponse;
import com.oracle.bmc.adm.responses.GetVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetWorkRequestResponse;
import com.oracle.bmc.adm.responses.ListApplicationDependencyRecommendationsResponse;
import com.oracle.bmc.adm.responses.ListApplicationDependencyVulnerabilitiesResponse;
import com.oracle.bmc.adm.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.adm.responses.ListRemediationRecipesResponse;
import com.oracle.bmc.adm.responses.ListRemediationRunsResponse;
import com.oracle.bmc.adm.responses.ListStagesResponse;
import com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestsResponse;
import com.oracle.bmc.adm.responses.UpdateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.UpdateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.UpdateRemediationRunResponse;
import com.oracle.bmc.adm.responses.UpdateVulnerabilityAuditResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.reactor.AsyncHandlerSink;
import jakarta.inject.Singleton;
import reactor.core.publisher.Mono;

@Requires(classes={ApplicationDependencyManagementAsyncClient.class, Mono.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ApplicationDependencyManagementReactorClient {
    ApplicationDependencyManagementAsyncClient client;

    ApplicationDependencyManagementReactorClient(ApplicationDependencyManagementAsyncClient client) {
        this.client = client;
    }

    public Mono<ActivateRemediationRecipeResponse> activateRemediationRecipe(ActivateRemediationRecipeRequest request) {
        return Mono.create(sink -> this.client.activateRemediationRecipe(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelRemediationRunResponse> cancelRemediationRun(CancelRemediationRunRequest request) {
        return Mono.create(sink -> this.client.cancelRemediationRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Mono.create(sink -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeKnowledgeBaseCompartmentResponse> changeKnowledgeBaseCompartment(ChangeKnowledgeBaseCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeKnowledgeBaseCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeRemediationRecipeCompartmentResponse> changeRemediationRecipeCompartment(ChangeRemediationRecipeCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeRemediationRecipeCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeRemediationRunCompartmentResponse> changeRemediationRunCompartment(ChangeRemediationRunCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeRemediationRunCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ChangeVulnerabilityAuditCompartmentResponse> changeVulnerabilityAuditCompartment(ChangeVulnerabilityAuditCompartmentRequest request) {
        return Mono.create(sink -> this.client.changeVulnerabilityAuditCompartment(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateKnowledgeBaseResponse> createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.createKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateRemediationRecipeResponse> createRemediationRecipe(CreateRemediationRecipeRequest request) {
        return Mono.create(sink -> this.client.createRemediationRecipe(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateRemediationRunResponse> createRemediationRun(CreateRemediationRunRequest request) {
        return Mono.create(sink -> this.client.createRemediationRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<CreateVulnerabilityAuditResponse> createVulnerabilityAudit(CreateVulnerabilityAuditRequest request) {
        return Mono.create(sink -> this.client.createVulnerabilityAudit(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeactivateRemediationRecipeResponse> deactivateRemediationRecipe(DeactivateRemediationRecipeRequest request) {
        return Mono.create(sink -> this.client.deactivateRemediationRecipe(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteKnowledgeBaseResponse> deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.deleteKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRemediationRecipeResponse> deleteRemediationRecipe(DeleteRemediationRecipeRequest request) {
        return Mono.create(sink -> this.client.deleteRemediationRecipe(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteRemediationRunResponse> deleteRemediationRun(DeleteRemediationRunRequest request) {
        return Mono.create(sink -> this.client.deleteRemediationRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<DeleteVulnerabilityAuditResponse> deleteVulnerabilityAudit(DeleteVulnerabilityAuditRequest request) {
        return Mono.create(sink -> this.client.deleteVulnerabilityAudit(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetKnowledgeBaseResponse> getKnowledgeBase(GetKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.getKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRemediationRecipeResponse> getRemediationRecipe(GetRemediationRecipeRequest request) {
        return Mono.create(sink -> this.client.getRemediationRecipe(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetRemediationRunResponse> getRemediationRun(GetRemediationRunRequest request) {
        return Mono.create(sink -> this.client.getRemediationRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetStageResponse> getStage(GetStageRequest request) {
        return Mono.create(sink -> this.client.getStage(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetVulnerabilityAuditResponse> getVulnerabilityAudit(GetVulnerabilityAuditRequest request) {
        return Mono.create(sink -> this.client.getVulnerabilityAudit(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Mono.create(sink -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListApplicationDependencyRecommendationsResponse> listApplicationDependencyRecommendations(ListApplicationDependencyRecommendationsRequest request) {
        return Mono.create(sink -> this.client.listApplicationDependencyRecommendations(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListApplicationDependencyVulnerabilitiesResponse> listApplicationDependencyVulnerabilities(ListApplicationDependencyVulnerabilitiesRequest request) {
        return Mono.create(sink -> this.client.listApplicationDependencyVulnerabilities(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListKnowledgeBasesResponse> listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return Mono.create(sink -> this.client.listKnowledgeBases(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRemediationRecipesResponse> listRemediationRecipes(ListRemediationRecipesRequest request) {
        return Mono.create(sink -> this.client.listRemediationRecipes(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListRemediationRunsResponse> listRemediationRuns(ListRemediationRunsRequest request) {
        return Mono.create(sink -> this.client.listRemediationRuns(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListStagesResponse> listStages(ListStagesRequest request) {
        return Mono.create(sink -> this.client.listStages(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListVulnerabilityAuditsResponse> listVulnerabilityAudits(ListVulnerabilityAuditsRequest request) {
        return Mono.create(sink -> this.client.listVulnerabilityAudits(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Mono.create(sink -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateKnowledgeBaseResponse> updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        return Mono.create(sink -> this.client.updateKnowledgeBase(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRemediationRecipeResponse> updateRemediationRecipe(UpdateRemediationRecipeRequest request) {
        return Mono.create(sink -> this.client.updateRemediationRecipe(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateRemediationRunResponse> updateRemediationRun(UpdateRemediationRunRequest request) {
        return Mono.create(sink -> this.client.updateRemediationRun(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }

    public Mono<UpdateVulnerabilityAuditResponse> updateVulnerabilityAudit(UpdateVulnerabilityAuditRequest request) {
        return Mono.create(sink -> this.client.updateVulnerabilityAudit(request, (AsyncHandler)new AsyncHandlerSink(sink)));
    }
}

