/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.messaging;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.naming.Described;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.messaging.annotation.MessageListener;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.EmbeddedApplication;
import io.micronaut.runtime.event.ApplicationShutdownEvent;
import io.micronaut.runtime.event.ApplicationStartupEvent;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import jakarta.inject.Singleton;
import java.util.Collection;
import org.jspecify.annotations.NonNull;

@Singleton
@Requires(missingBeans={EmbeddedApplication.class})
public class MessagingApplication
implements EmbeddedApplication<MessagingApplication>,
Described {
    private final ApplicationContext applicationContext;
    private final ApplicationConfiguration configuration;

    public MessagingApplication(ApplicationContext applicationContext, ApplicationConfiguration configuration) {
        this.applicationContext = applicationContext;
        this.configuration = configuration;
    }

    public @NonNull ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.configuration;
    }

    public boolean isRunning() {
        return this.applicationContext.isRunning();
    }

    public boolean isServer() {
        return true;
    }

    public @NonNull MessagingApplication start() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (!applicationContext.isRunning()) {
            try {
                applicationContext.start();
            }
            catch (Throwable e) {
                throw new ApplicationStartupException("Error starting messaging server: " + e.getMessage(), e);
            }
        }
        applicationContext.publishEvent((Object)new ApplicationStartupEvent((EmbeddedApplication)this));
        return this;
    }

    public @NonNull MessagingApplication stop() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext.isRunning()) {
            applicationContext.publishEvent((Object)new ApplicationShutdownEvent((EmbeddedApplication)this));
            applicationContext.stop();
        }
        return this;
    }

    public @NonNull String getDescription() {
        Collection beanDefinitions = this.applicationContext.getBeanDefinitions(Qualifiers.byStereotype(MessageListener.class));
        return beanDefinitions.size() + " active message listeners.";
    }
}

