/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaEnumConstantElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@Internal
class JavaEnumElement
extends JavaClassElement
implements EnumElement {
    protected List<EnumConstantElement> enumConstants;
    protected List<String> values;

    JavaEnumElement(JavaNativeElement.Class nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext, String doc) {
        this(nativeElement, annotationMetadataFactory, visitorContext, 0, doc);
    }

    JavaEnumElement(JavaNativeElement.Class nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext, int arrayDimensions, String doc) {
        super(nativeElement, annotationMetadataFactory, visitorContext, Collections.emptyList(), Collections.emptyMap(), arrayDimensions, false, doc);
    }

    @Override
    protected JavaClassElement copyThis() {
        return new JavaEnumElement(this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext, this.arrayDimensions, this.doc);
    }

    public List<String> values() {
        if (this.values != null) {
            return this.values;
        }
        this.initEnum();
        return this.values;
    }

    public List<EnumConstantElement> elements() {
        if (this.enumConstants != null) {
            return this.enumConstants;
        }
        this.initEnum();
        return this.enumConstants;
    }

    private void initEnum() {
        this.values = new ArrayList<String>();
        this.enumConstants = new ArrayList<EnumConstantElement>();
        TypeElement nativeType = this.getNativeType().element();
        for (Element element : nativeType.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            this.values.add(element.getSimpleName().toString());
            this.enumConstants.add(new JavaEnumConstantElement(this, new JavaNativeElement.Variable((VariableElement)element), this.elementAnnotationMetadataFactory, this.visitorContext));
        }
        this.values = Collections.unmodifiableList(this.values);
        this.enumConstants = Collections.unmodifiableList(this.enumConstants);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new JavaEnumElement(this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext, arrayDimensions, this.doc);
    }
}

