/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AbstractInjectAnnotationProcessor;
import io.micronaut.annotation.processing.JavaElementAnnotationMetadataFactory;
import io.micronaut.annotation.processing.PostponeToNextRoundException;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.context.annotation.Mixin;
import io.micronaut.context.visitor.VisitorUtils;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Generated;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.ElementPostponedToNextRoundException;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.TypeElement;

@SupportedOptions(value={"micronaut.processing.incremental", "micronaut.processing.annotations", "micronaut.processing.project.dir", "micronaut.processing.group", "micronaut.processing.module"})
public class MixinVisitorProcessor
extends AbstractInjectAnnotationProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Mixin.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.size() != 1 || !Generated.class.getName().equals(annotations.iterator().next().getQualifiedName().toString())) {
            for (Object nativeType : this.postponedTypes.values()) {
                AbstractAnnotationMetadataBuilder.clearMutated(nativeType);
            }
            LinkedHashSet elements = new LinkedHashSet();
            this.postponedTypes.keySet().stream().map(this.elementUtils::getTypeElement).filter(Objects::nonNull).forEach(elements::add);
            this.postponedTypes.clear();
            JavaElementFactory elementFactory = this.javaVisitorContext.getElementFactory();
            JavaElementAnnotationMetadataFactory elementAnnotationMetadataFactory = this.javaVisitorContext.getElementAnnotationMetadataFactory();
            for (TypeElement typeElement2 : annotations) {
                this.modelUtils.resolveTypeElements(roundEnv.getElementsAnnotatedWith(typeElement2)).forEach(elements::add);
            }
            List<JavaClassElement> javaClassElements = elements.stream().map(typeElement -> elementFactory.newSourceClassElement((TypeElement)typeElement, (ElementAnnotationMetadataFactory)elementAnnotationMetadataFactory)).toList();
            for (JavaClassElement mixin : javaClassElements) {
                try {
                    String target;
                    AnnotationValue mixinAnnotation = mixin.getAnnotation(Mixin.class);
                    if (mixinAnnotation == null || (target = mixinAnnotation.stringValue("target").orElse(mixinAnnotation.stringValue().orElse(null))) == null || Object.class.getName().equals(target)) continue;
                    ClassElement mixinTarget = this.javaVisitorContext.getClassElement(target, (ElementAnnotationMetadataFactory)elementAnnotationMetadataFactory).orElse(null);
                    if (mixinTarget == null) {
                        this.javaVisitorContext.warn("Cannot access class: " + target, (Element)mixin);
                        continue;
                    }
                    VisitorUtils.applyMixin((AnnotationValue)mixinAnnotation, (ClassElement)mixin, (ClassElement)mixinTarget, (VisitorContext)this.javaVisitorContext);
                }
                catch (ProcessingException e) {
                    JavaNativeElement originatingElement = (JavaNativeElement)e.getOriginatingElement();
                    if (originatingElement == null) {
                        originatingElement = mixin.getNativeType();
                    }
                    this.error(originatingElement.element(), e.getMessage(), new Object[0]);
                }
                catch (PostponeToNextRoundException e) {
                    this.postponedTypes.put(mixin.getCanonicalName(), e.getNativeErrorElement());
                }
                catch (ElementPostponedToNextRoundException e) {
                    Object nativeType = e.getOriginatingElement().getNativeType();
                    javax.lang.model.element.Element element = PostponeToNextRoundException.resolvedFailedElement(nativeType);
                    if (element != null) {
                        this.postponedTypes.put(mixin.getCanonicalName(), element);
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (roundEnv.processingOver()) {
            this.javaVisitorContext.finish();
        }
        return false;
    }
}

