/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck.netty;

import io.micronaut.http.tck.netty.TestLeakDetector;
import io.netty.util.ResourceLeakDetector;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class LeakDetectionExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final boolean NETTY_AVAILABLE;

    public void beforeEach(ExtensionContext context) throws Exception {
        if (NETTY_AVAILABLE) {
            TestLeakDetector.startTracking(context.getDisplayName());
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (NETTY_AVAILABLE) {
            TestLeakDetector.stopTrackingAndReportLeaks();
        }
    }

    static {
        boolean available;
        try {
            ResourceLeakDetector.getLevel();
            available = true;
        }
        catch (NoClassDefFoundError e) {
            available = false;
        }
        NETTY_AVAILABLE = available;
        if (NETTY_AVAILABLE) {
            TestLeakDetector.init();
        }
    }
}

