/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.tck;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.tck.BodyAssertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class HttpResponseAssertion {
    private final HttpStatus httpStatus;
    private final Map<String, String> headers;
    private final List<BodyAssertion<?, ?>> bodyAssertions;
    @Nullable
    private final Consumer<HttpResponse<?>> responseConsumer;

    private HttpResponseAssertion(HttpStatus httpStatus, Map<String, String> headers, List<BodyAssertion<?, ?>> bodyAssertions, @Nullable Consumer<HttpResponse<?>> responseConsumer) {
        this.httpStatus = httpStatus;
        this.headers = headers;
        this.bodyAssertions = bodyAssertions;
        this.responseConsumer = responseConsumer;
    }

    @NonNull
    public Optional<Consumer<HttpResponse<?>>> getResponseConsumer() {
        return Optional.ofNullable(this.responseConsumer);
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<BodyAssertion<?, ?>> getBody() {
        return this.bodyAssertions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpStatus httpStatus;
        private Map<String, String> headers;
        private List<BodyAssertion<?, ?>> bodyAssertions;
        private Consumer<HttpResponse<?>> responseConsumer;

        public Builder assertResponse(Consumer<HttpResponse<?>> responseConsumer) {
            this.responseConsumer = responseConsumer;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder header(String headerName, String headerValue) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(headerName, headerValue);
            return this;
        }

        public Builder body(String containsBody) {
            return this.body(BodyAssertion.builder().body(containsBody).contains());
        }

        public Builder body(BodyAssertion<?, ?> bodyAssertion) {
            if (this.bodyAssertions == null) {
                this.bodyAssertions = new ArrayList();
            }
            this.bodyAssertions.add(bodyAssertion);
            return this;
        }

        public Builder status(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public HttpResponseAssertion build() {
            return new HttpResponseAssertion(Objects.requireNonNull(this.httpStatus), this.headers, this.bodyAssertions, this.responseConsumer);
        }
    }
}

