/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.stream.InputStreamByteBody;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.exceptions.MessageBodyException;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.body.AbstractFileBodyWriter;
import io.micronaut.http.server.types.files.SystemFile;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@Singleton
@Internal
public final class SystemFileBodyWriter
extends AbstractFileBodyWriter
implements ResponseBodyWriter<SystemFile> {
    private static final String UNIT_BYTES = "bytes";
    private final ExecutorService ioExecutor;

    public SystemFileBodyWriter(HttpServerConfiguration.FileTypeHandlerConfiguration configuration, @Named(value="blocking") ExecutorService ioExecutor) {
        super(configuration);
        this.ioExecutor = ioExecutor;
    }

    public void writeTo(Argument<SystemFile> type, MediaType mediaType, SystemFile file, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        throw new UnsupportedOperationException("Can only be used in a Netty context");
    }

    public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, HttpRequest<?> request, @NonNull MutableHttpResponse<SystemFile> httpResponse, @NonNull Argument<SystemFile> type, @NonNull MediaType mediaType, SystemFile object) throws CodecException {
        return this.write(bodyFactory, request, httpResponse, object);
    }

    public ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, HttpRequest<?> request, MutableHttpResponse<SystemFile> response, SystemFile systemFile) throws CodecException {
        FileInputStream is;
        if (!systemFile.getFile().canRead()) {
            throw new MessageBodyException("Could not find file");
        }
        if (this.handleIfModifiedAndHeaders(request, response, systemFile, response)) {
            return this.notModified(bodyFactory, response);
        }
        long fileLength = systemFile.getLength();
        long position = 0L;
        long contentLength = fileLength;
        if (fileLength > -1L) {
            IntRange range;
            String rangeHeader = (String)request.getHeaders().get((CharSequence)"Range");
            if (rangeHeader != null && request.getMethod() == HttpMethod.GET && rangeHeader.startsWith(UNIT_BYTES) && response.status() == HttpStatus.OK && (range = SystemFileBodyWriter.parseRangeHeader(rangeHeader, fileLength)) != null && range.firstPos < range.lastPos && range.firstPos < fileLength && range.lastPos < fileLength) {
                position = range.firstPos;
                contentLength = range.lastPos + 1L - range.firstPos;
                response.status(HttpStatus.PARTIAL_CONTENT);
                response.header((CharSequence)"Content-Range", (CharSequence)"%s %d-%d/%d".formatted(UNIT_BYTES, range.firstPos, range.lastPos, fileLength));
            }
            response.header((CharSequence)"Accept-Ranges", (CharSequence)UNIT_BYTES);
        }
        File file = systemFile.getFile();
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MessageBodyException("Could not find file", (Throwable)e);
        }
        @NonNull RangeInputStream stream = new RangeInputStream(is, position, contentLength);
        return ByteBodyHttpResponseWrapper.wrap(response, (CloseableByteBody)InputStreamByteBody.create((InputStream)stream, (OptionalLong)OptionalLong.of(contentLength), (Executor)this.ioExecutor, (ByteBodyFactory)bodyFactory));
    }

    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<SystemFile> type, @NonNull MediaType mediaType, SystemFile object) {
        return this.writePiece(bodyFactory, object);
    }

    @NonNull
    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, SystemFile object) {
        FileInputStream is;
        long fileLength = object.getLength();
        try {
            is = new FileInputStream(object.getFile());
        }
        catch (FileNotFoundException e) {
            throw new MessageBodyException("Could not find file", (Throwable)e);
        }
        return InputStreamByteBody.create((InputStream)is, (OptionalLong)OptionalLong.of(fileLength), (Executor)this.ioExecutor, (ByteBodyFactory)bodyFactory);
    }

    @Nullable
    private static IntRange parseRangeHeader(String value, long contentLength) {
        int equalsIdx = value.indexOf(61);
        if (equalsIdx < 0 || equalsIdx == value.length() - 1) {
            return null;
        }
        int minusIdx = value.indexOf(45, equalsIdx + 1);
        if (minusIdx < 0) {
            return null;
        }
        String from = value.substring(equalsIdx + 1, minusIdx).trim();
        String to = value.substring(minusIdx + 1).trim();
        try {
            long fromPosition = from.isEmpty() ? 0L : Long.parseLong(from);
            long toPosition = to.isEmpty() ? contentLength - 1L : Long.parseLong(to);
            return new IntRange(fromPosition, toPosition);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class IntRange {
        private final long firstPos;
        private final long lastPos;

        IntRange(long firstPos, long lastPos) {
            this.firstPos = firstPos;
            this.lastPos = lastPos;
        }
    }

    private static final class RangeInputStream
    extends InputStream {
        private final InputStream delegate;
        private final long toSkip;
        private long remainingLength;
        private boolean skipped = false;
        private boolean skipSuccess = false;

        private RangeInputStream(InputStream delegate, long toSkip, long length) {
            this.delegate = delegate;
            this.toSkip = toSkip;
            this.remainingLength = length;
            if (toSkip == 0L) {
                this.skipped = true;
                this.skipSuccess = true;
            }
        }

        private boolean doSkip() throws IOException {
            if (!this.skipped) {
                this.skipped = true;
                try {
                    this.delegate.skipNBytes(this.toSkip);
                    this.skipSuccess = true;
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
            }
            return this.skipSuccess;
        }

        @Override
        public int read() throws IOException {
            if (!this.doSkip()) {
                return -1;
            }
            if (this.remainingLength <= 0L) {
                return -1;
            }
            int read = this.delegate.read();
            if (read != -1) {
                --this.remainingLength;
            }
            return read;
        }

        @Override
        public int read(@NonNull byte[] b, int off, int len) throws IOException {
            int n;
            if (!this.doSkip()) {
                return -1;
            }
            if (this.remainingLength <= 0L) {
                return -1;
            }
            if ((long)len > this.remainingLength) {
                len = (int)this.remainingLength;
            }
            if ((n = this.delegate.read(b, off, len)) != -1) {
                this.remainingLength -= (long)n;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

