/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.Pool;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import org.slf4j.Logger;

@Internal
final class Pool40
implements Pool {
    private final Pool.Listener listener;
    private final Logger log;
    private final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration;
    private final EventLoopGroup group;
    private final AtomicReference<WorkState> state = new AtomicReference<WorkState>(WorkState.IDLE);
    private final AtomicInteger pendingConnectionCount = new AtomicInteger(0);
    private final Deque<PendingRequest> pendingRequests = new ConcurrentLinkedDeque<PendingRequest>();
    private final ConnectionList http1Connections = new ConnectionList();
    private final ConnectionList http2Connections = new ConnectionList();

    Pool40(Pool.Listener listener, Logger log, HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration, EventLoopGroup group) {
        this.listener = listener;
        this.log = log;
        this.connectionPoolConfiguration = connectionPoolConfiguration;
        this.group = group;
    }

    @Override
    public Pool.PendingRequest createPendingRequest(@Nullable BlockHint blockHint) {
        return new PendingRequest(blockHint);
    }

    @Override
    public Pool.Http1PoolEntry createHttp1PoolEntry(@NonNull EventLoop eventLoop, @NonNull Pool.ResizerConnection connection) {
        return new Http1(eventLoop, connection);
    }

    @Override
    public Pool.Http2PoolEntry createHttp2PoolEntry(@NonNull EventLoop eventLoop, @NonNull Pool.ResizerConnection connection) {
        return new Http2(eventLoop, connection);
    }

    @Override
    public void onNewConnectionFailure(@NonNull EventLoop eventLoop, @Nullable Throwable error) throws Exception {
        this.onNewConnectionFailure(error);
    }

    private void dirty() {
        WorkState endState;
        WorkState before = this.state.getAndUpdate(ws -> {
            if (ws == WorkState.IDLE) {
                return WorkState.ACTIVE_WITHOUT_PENDING_WORK;
            }
            return WorkState.ACTIVE_WITH_PENDING_WORK;
        });
        if (before != WorkState.IDLE) {
            return;
        }
        do {
            try {
                this.doSomeWork();
            }
            catch (Throwable t) {
                this.state.set(WorkState.IDLE);
                throw t;
            }
        } while ((endState = this.state.updateAndGet(ws -> {
            if (ws == WorkState.ACTIVE_WITH_PENDING_WORK) {
                return WorkState.ACTIVE_WITHOUT_PENDING_WORK;
            }
            return WorkState.IDLE;
        })) != WorkState.IDLE);
    }

    private PoolEntry[] sort(PendingRequest request, ConnectionList connections) {
        PoolEntry[] items = connections.unsafeItems;
        if (items.length == 0) {
            return items;
        }
        HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality locality = this.connectionPoolConfiguration.getConnectionLocality();
        if (locality == HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.PREFERRED) {
            int copies = 0;
            for (int i = 1; i < items.length; ++i) {
                PoolEntry connection = items[i];
                if (!connection.eventLoop.inEventLoop(request.requestingThread)) continue;
                System.arraycopy(items, 0, items, 1, i);
                items[0] = connection;
                if (copies++ <= 4) {
                    continue;
                }
                break;
            }
        } else if (locality == HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.ENFORCED_IF_SAME_GROUP || locality == HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.ENFORCED_ALWAYS) {
            ArrayList<PoolEntry> options = new ArrayList<PoolEntry>();
            for (PoolEntry item : items) {
                if (!item.eventLoop.inEventLoop(request.requestingThread)) continue;
                options.add(item);
            }
            if (!options.isEmpty() || locality == HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.ENFORCED_ALWAYS || this.containsThread(request.requestingThread)) {
                return options.toArray(new PoolEntry[0]);
            }
        }
        return items;
    }

    private void doSomeWork() {
        PendingRequest toDispatch;
        BlockHint blockedPendingRequests = null;
        while ((toDispatch = this.pendingRequests.pollFirst()) != null) {
            boolean dispatched = false;
            for (PoolEntry c : this.sort(toDispatch, this.http2Connections)) {
                if (!this.dispatchSafe(c, toDispatch)) continue;
                dispatched = true;
                break;
            }
            if (!dispatched) {
                for (PoolEntry c : this.sort(toDispatch, this.http1Connections)) {
                    if (!this.dispatchSafe(c, toDispatch)) continue;
                    dispatched = true;
                    break;
                }
            }
            if (dispatched) continue;
            this.pendingRequests.addFirst(toDispatch);
            blockedPendingRequests = BlockHint.combine(blockedPendingRequests, toDispatch.blockHint);
            break;
        }
        int pendingRequestCount = this.pendingRequests.size();
        int pendingConnectionCount = this.pendingConnectionCount.get();
        int http1ConnectionCount = this.http1Connections.unsafeItems.length;
        int http2ConnectionCount = this.http2Connections.unsafeItems.length;
        if (pendingRequestCount == 0) {
            return;
        }
        int connectionsToOpen = pendingRequestCount - pendingConnectionCount;
        connectionsToOpen = Math.min(connectionsToOpen, this.connectionPoolConfiguration.getMaxPendingConnections() - pendingConnectionCount);
        if (http1ConnectionCount > 0 || http2ConnectionCount == 0) {
            connectionsToOpen = Math.min(connectionsToOpen, this.connectionPoolConfiguration.getMaxConcurrentHttp1Connections() - http1ConnectionCount);
        }
        if (http2ConnectionCount > 0 || http1ConnectionCount == 0) {
            connectionsToOpen = Math.min(connectionsToOpen, this.connectionPoolConfiguration.getMaxConcurrentHttp2Connections() - http2ConnectionCount);
        }
        if (connectionsToOpen > 0) {
            Iterator<PendingRequest> pendingRequestIterator = this.pendingRequests.iterator();
            if (!pendingRequestIterator.hasNext()) {
                return;
            }
            Thread preferredThread = pendingRequestIterator.next().requestingThread;
            this.pendingConnectionCount.addAndGet(connectionsToOpen);
            for (int i = 0; i < connectionsToOpen; ++i) {
                try {
                    this.openNewConnection(blockedPendingRequests, preferredThread);
                }
                catch (Exception e) {
                    try {
                        this.onNewConnectionFailure(e);
                    }
                    catch (Exception f) {
                        this.log.error("Internal error", (Throwable)f);
                    }
                }
                if (!pendingRequestIterator.hasNext()) continue;
                preferredThread = pendingRequestIterator.next().requestingThread;
            }
            this.dirty();
        }
    }

    private boolean dispatchSafe(PoolEntry connection, PendingRequest toDispatch) {
        try {
            BlockHint blockHint = toDispatch.blockHint;
            if (blockHint != null && blockHint.blocks((EventExecutor)connection.eventLoop)) {
                toDispatch.tryCompleteExceptionally(BlockHint.createException());
                return true;
            }
            if (!connection.tryEarmarkForRequest()) {
                return false;
            }
            connection.connection.dispatch(toDispatch);
            return true;
        }
        catch (Exception e) {
            try {
                if (!toDispatch.tryCompleteExceptionally(e)) {
                    this.log.debug("Failure during connection dispatch operation, but dispatch request was already complete.", (Throwable)e);
                }
            }
            catch (Exception f) {
                this.log.error("Internal error", (Throwable)f);
            }
            return true;
        }
    }

    void openNewConnection(@Nullable BlockHint blockedPendingRequests, @NonNull Thread requestingThread) throws Exception {
        EventLoop target = null;
        for (EventExecutor executor : this.group) {
            if (!executor.inEventLoop(requestingThread)) continue;
            target = (EventLoop)executor;
            break;
        }
        if (target == null) {
            target = this.group.next();
        }
        if (blockedPendingRequests != null && blockedPendingRequests.blocks((EventExecutor)target)) {
            this.onNewConnectionFailure(BlockHint.createException());
            return;
        }
        this.listener.openNewConnection(target);
    }

    boolean containsThread(@NonNull Thread thread) {
        for (EventExecutor executor : this.group) {
            if (!executor.inEventLoop(thread)) continue;
            return true;
        }
        return false;
    }

    void onNewConnectionFailure(@Nullable Throwable error) throws Exception {
        this.pendingConnectionCount.decrementAndGet();
        this.dirty();
        PendingRequest pending = this.pollPendingRequest();
        if (pending != null && pending.tryCompleteExceptionally(this.listener.wrapError(error))) {
            return;
        }
        this.log.error("Failed to connect to remote", error);
    }

    void onNewConnectionEstablished1(Http1 connection) {
        this.http1Connections.add(connection);
        this.pendingConnectionCount.decrementAndGet();
        this.dirty();
    }

    void onNewConnectionEstablished2(Http2 connection) {
        this.http2Connections.add(connection);
        this.pendingConnectionCount.decrementAndGet();
        this.dirty();
    }

    void onConnectionInactive1(Http1 connection) {
        this.http1Connections.remove(connection);
        this.dirty();
    }

    void onConnectionInactive2(Http2 connection) {
        this.http2Connections.remove(connection);
        this.dirty();
    }

    void addPendingRequest(PendingRequest sink) {
        int maxPendingAcquires = this.connectionPoolConfiguration.getMaxPendingAcquires();
        if (maxPendingAcquires != Integer.MAX_VALUE && this.pendingRequests.size() >= maxPendingAcquires) {
            sink.tryCompleteExceptionally(new HttpClientException("Cannot acquire connection, exceeded max pending acquires configuration"));
            return;
        }
        this.pendingRequests.addLast(sink);
        this.dirty();
    }

    PendingRequest pollPendingRequest() {
        PendingRequest req = this.pendingRequests.pollFirst();
        if (req != null) {
            this.dirty();
        }
        return req;
    }

    void markConnectionAvailable() {
        this.dirty();
    }

    @Override
    public void forEachConnection(Consumer<Pool.ResizerConnection> c) {
        this.http1Connections.forEach(c);
        this.http2Connections.forEach(c);
    }

    private static enum WorkState {
        IDLE,
        ACTIVE_WITH_PENDING_WORK,
        ACTIVE_WITHOUT_PENDING_WORK;

    }

    private static final class ConnectionList {
        private static final PoolEntry[] EMPTY = new PoolEntry[0];
        private final Lock lock = new ReentrantLock();
        private volatile PoolEntry[] unsafeItems = EMPTY;
        private PoolEntry[] safeItems = EMPTY;

        private ConnectionList() {
        }

        void forEach(Consumer<Pool.ResizerConnection> c) {
            PoolEntry[] items;
            this.lock.lock();
            try {
                items = this.safeItems;
            }
            finally {
                this.lock.unlock();
            }
            for (PoolEntry item : items) {
                c.accept(item.connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(PoolEntry connection) {
            this.lock.lock();
            try {
                PoolEntry[] prev = this.safeItems;
                PoolEntry[] next = Arrays.copyOf(prev, prev.length + 1);
                next[prev.length] = connection;
                this.safeItems = next;
                this.unsafeItems = (PoolEntry[])next.clone();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(PoolEntry connection) {
            this.lock.lock();
            try {
                PoolEntry[] prev = this.safeItems;
                int index = Arrays.asList(prev).indexOf(connection);
                if (index == -1) {
                    return;
                }
                PoolEntry[] next = Arrays.copyOf(prev, prev.length - 1);
                System.arraycopy(prev, index + 1, next, index, prev.length - index - 1);
                this.safeItems = next;
                this.unsafeItems = (PoolEntry[])next.clone();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    final class PendingRequest
    extends AtomicBoolean
    implements Pool.PendingRequest {
        final Thread requestingThread = Thread.currentThread();
        @Nullable
        final BlockHint blockHint;
        private final DelayedExecutionFlow<ConnectionManager.PoolHandle> sink = DelayedExecutionFlow.create();

        PendingRequest(BlockHint blockHint) {
            this.blockHint = blockHint;
        }

        @Override
        public ExecutionFlow<ConnectionManager.PoolHandle> flow() {
            return this.sink;
        }

        @Override
        public void dispatch() {
            Pool40.this.addPendingRequest(this);
        }

        @Override
        public void redispatch() {
            this.dispatch();
        }

        @Override
        @Nullable
        public EventExecutor likelyEventLoop() {
            return null;
        }

        boolean tryCompleteExceptionally(Throwable t) {
            if (this.compareAndSet(false, true)) {
                this.sink.completeExceptionally(t);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryComplete(ConnectionManager.PoolHandle value) {
            if (this.compareAndSet(false, true)) {
                if (this.sink.isCancelled()) {
                    return false;
                }
                this.sink.complete((Object)value);
                return true;
            }
            return false;
        }
    }

    final class Http1
    extends PoolEntry
    implements Pool.Http1PoolEntry {
        private final AtomicBoolean earmarkedOrLive;

        public Http1(@NonNull EventLoop eventLoop, Pool.ResizerConnection connection) {
            super(eventLoop, connection);
            this.earmarkedOrLive = new AtomicBoolean(false);
        }

        @Override
        public void onConnectionEstablished() {
            Pool40.this.onNewConnectionEstablished1(this);
        }

        @Override
        public void onConnectionInactive() {
            Pool40.this.onConnectionInactive1(this);
        }

        @Override
        boolean tryEarmarkForRequest() {
            return this.earmarkedOrLive.compareAndSet(false, true);
        }

        @Override
        public void markAvailable() {
            this.earmarkedOrLive.set(false);
            Pool40.this.markConnectionAvailable();
        }

        @Override
        public void markUnavailable() {
            this.earmarkedOrLive.set(true);
        }
    }

    final class Http2
    extends PoolEntry
    implements Pool.Http2PoolEntry {
        private final AtomicInteger earmarkedOrLiveRequests;
        private int maxStreamCount;

        public Http2(@NonNull EventLoop eventLoop, Pool.ResizerConnection connection) {
            super(eventLoop, connection);
            this.earmarkedOrLiveRequests = new AtomicInteger(0);
        }

        @Override
        boolean tryEarmarkForRequest() {
            IntUnaryOperator upd = old -> {
                if (old >= Math.min(Pool40.this.connectionPoolConfiguration.getMaxConcurrentRequestsPerHttp2Connection(), this.maxStreamCount)) {
                    return old;
                }
                return old + 1;
            };
            int old2 = this.earmarkedOrLiveRequests.updateAndGet(upd);
            return upd.applyAsInt(old2) != old2;
        }

        @Override
        public void onConnectionEstablished(int maxStreamCount) {
            this.maxStreamCount = maxStreamCount;
            Pool40.this.onNewConnectionEstablished2(this);
        }

        @Override
        public void onConnectionInactive() {
            Pool40.this.onConnectionInactive2(this);
        }

        @Override
        public void markAvailable() {
            this.earmarkedOrLiveRequests.decrementAndGet();
            Pool40.this.markConnectionAvailable();
        }

        @Override
        public void markUnavailable() {
            this.earmarkedOrLiveRequests.set(Integer.MAX_VALUE);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class PoolEntry {
        final EventLoop eventLoop;
        final Pool.ResizerConnection connection;

        private PoolEntry(EventLoop eventLoop, Pool.ResizerConnection connection) {
            this.eventLoop = eventLoop;
            this.connection = connection;
        }

        abstract boolean tryEarmarkForRequest();
    }
}

