/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.CancellableMonoSink;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.netty.DefaultHttpClientBuilder;
import io.micronaut.http.client.netty.Http2PingSender;
import io.micronaut.http.client.netty.InitialConnectionErrorHandler;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.Pool;
import io.micronaut.http.client.netty.Pool40;
import io.micronaut.http.client.netty.Pool49;
import io.micronaut.http.client.netty.ssl.ClientSslBuilder;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.netty.ssl.NettyClientSslFactory;
import io.micronaut.http.netty.NettySslContextBuilder;
import io.micronaut.http.netty.SslContextAutoLoader;
import io.micronaut.http.netty.SslContextHolder;
import io.micronaut.http.ssl.AbstractClientSslConfiguration;
import io.micronaut.http.ssl.CertificateProvider;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexActiveStreamsException;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.codec.http3.Http3;
import io.netty.handler.codec.http3.Http3ClientConnectionHandler;
import io.netty.handler.codec.http3.Http3FrameToHttpObjectCodec;
import io.netty.handler.codec.http3.Http3HeadersFrame;
import io.netty.handler.codec.http3.Http3RequestStreamInitializer;
import io.netty.handler.codec.http3.Http3SettingsFrame;
import io.netty.handler.codec.quic.QuicChannel;
import io.netty.handler.codec.quic.QuicClientCodecBuilder;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.codec.quic.QuicStreamChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.DefaultNameResolver;
import io.netty.resolver.InetSocketAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.resolver.RoundRobinInetAddressResolver;
import io.netty.util.NettyRuntime;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Internal
public class ConnectionManager {
    final NettyClientCustomizer clientCustomizer;
    private final HttpVersionSelection httpVersion;
    private final Logger log;
    private final Map<DefaultHttpClient.RequestKey, PoolHolder> pools = new ConcurrentHashMap<DefaultHttpClient.RequestKey, PoolHolder>();
    private final ClientSslBuilder nettyClientSslBuilder;
    private final NettyClientSslFactory sslFactory;
    private final BeanProvider<CertificateProvider> certificateProviders;
    private EventLoopGroup group;
    private final boolean shutdownGroup;
    private final AddressResolverGroup<?> resolverGroup;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ThreadFactory threadFactory;
    private final ChannelFactory<? extends Channel> socketChannelFactory;
    private final ChannelFactory<? extends Channel> udpChannelFactory;
    private Bootstrap bootstrap;
    private Bootstrap udpBootstrap;
    private final HttpClientConfiguration configuration;
    private SslContextAutoLoader sslContextWrapper;
    private SslContextAutoLoader sslContextWrapperWs;
    private volatile boolean wsContextLoaded;
    private final String informationalServiceId;

    ConnectionManager(ConnectionManager from) {
        this.httpVersion = from.httpVersion;
        this.log = from.log;
        this.group = from.group;
        this.shutdownGroup = from.shutdownGroup;
        this.resolverGroup = from.resolverGroup;
        this.threadFactory = from.threadFactory;
        this.socketChannelFactory = from.socketChannelFactory;
        this.udpChannelFactory = from.udpChannelFactory;
        this.bootstrap = from.bootstrap;
        this.udpBootstrap = from.udpBootstrap;
        this.configuration = from.configuration;
        this.clientCustomizer = from.clientCustomizer;
        this.informationalServiceId = from.informationalServiceId;
        this.nettyClientSslBuilder = from.nettyClientSslBuilder;
        this.sslFactory = from.sslFactory;
        this.certificateProviders = from.certificateProviders;
        this.sslContextWrapper = from.sslContextWrapper;
        this.sslContextWrapperWs = from.sslContextWrapperWs;
        this.running.set(from.running.get());
    }

    ConnectionManager(Logger log, HttpClientConfiguration configuration, DefaultHttpClientBuilder builder) {
        BeanProvider<CertificateProvider> beanProvider;
        this.httpVersion = builder.explicitHttpVersion == null ? HttpVersionSelection.forClientConfiguration((HttpClientConfiguration)configuration) : builder.explicitHttpVersion;
        this.log = log;
        this.threadFactory = builder.threadFactory == null ? new DefaultThreadFactory(MultithreadEventLoopGroup.class) : builder.threadFactory;
        this.socketChannelFactory = builder.socketChannelFactory;
        this.udpChannelFactory = builder.udpChannelFactory;
        this.configuration = configuration;
        this.clientCustomizer = builder.clientCustomizer;
        this.informationalServiceId = builder.informationalServiceId;
        this.nettyClientSslBuilder = builder.nettyClientSslBuilder == null ? new NettyClientSslBuilder(new ResourceResolver()) : builder.nettyClientSslBuilder;
        NettyClientSslFactory nettyClientSslFactory = this.sslFactory = builder.sslFactory == null ? new NettyClientSslFactory() : builder.sslFactory;
        if (builder.certificateProviders == null) {
            BeanProvider<CertificateProvider> beanProvider2;
            beanProvider = beanProvider2;
        } else {
            beanProvider = builder.certificateProviders;
        }
        this.certificateProviders = beanProvider;
        this.sslContextWrapper = new ClientContextWrapper(false);
        this.sslContextWrapperWs = new ClientContextWrapper(true);
        if (builder.eventLoopGroup != null) {
            this.group = builder.eventLoopGroup;
            this.shutdownGroup = false;
        } else {
            this.group = ConnectionManager.createEventLoopGroup(configuration, this.threadFactory);
            this.shutdownGroup = true;
        }
        this.resolverGroup = builder.resolverGroup == null ? ConnectionManager.getResolver(configuration.getDnsResolutionMode()) : builder.resolverGroup;
        this.refresh();
    }

    final void refresh() {
        if (this.httpVersion.isHttp3() || this.configuration.getSslConfiguration().isEnabled()) {
            this.sslContextWrapper.autoLoad();
        } else {
            this.sslContextWrapper.clear();
        }
        this.sslContextWrapperWs.clear();
        this.wsContextLoaded = false;
        this.initBootstrap();
        this.running.set(true);
        for (PoolHolder pool : this.pools.values()) {
            pool.pool.forEachConnection(c -> ((PoolHolder.ConnectionHolder)c).windDownConnection());
        }
    }

    private static EventLoopGroup createEventLoopGroup(HttpClientConfiguration configuration, ThreadFactory threadFactory) {
        if (configuration.getThreadFactory().isPresent()) {
            threadFactory = (ThreadFactory)InstantiationUtils.instantiate((Class)((Class)configuration.getThreadFactory().get()));
        }
        return new MultiThreadIoEventLoopGroup(configuration.getNumOfThreads().orElseGet(NettyRuntime::availableProcessors), threadFactory, NioIoHandler.newFactory());
    }

    public final ByteBufAllocator alloc() {
        return this.bootstrap.config().options().getOrDefault(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT);
    }

    EventLoopGroup getGroup() {
        return this.group;
    }

    @NonNull
    final List<Channel> getChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (PoolHolder pool : this.pools.values()) {
            pool.pool.forEachConnection(c -> channels.add(((PoolHolder.ConnectionHolder)c).channel));
        }
        return channels;
    }

    final int liveRequestCount() {
        AtomicInteger count = new AtomicInteger();
        for (PoolHolder pool : this.pools.values()) {
            pool.pool.forEachConnection(c -> {
                if (c instanceof PoolHolder.Http1ConnectionHolder) {
                    PoolHolder.Http1ConnectionHolder holder = (PoolHolder.Http1ConnectionHolder)c;
                    if (holder.hasLiveRequests()) {
                        count.incrementAndGet();
                    }
                } else {
                    count.addAndGet(((PoolHolder.Http2ConnectionHolder)c).liveRequests.get());
                }
            });
        }
        return count.get();
    }

    public final void start() {
        if (this.running.compareAndSet(false, true) && this.shutdownGroup) {
            this.group = ConnectionManager.createEventLoopGroup(this.configuration, this.threadFactory);
            this.initBootstrap();
        }
    }

    private void initBootstrap() {
        this.bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channelFactory(this.socketChannelFactory)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        if (this.httpVersion.isHttp3()) {
            this.udpBootstrap = (Bootstrap)new Bootstrap().channelFactory(this.udpChannelFactory);
        }
        Optional connectTimeout = this.configuration.getConnectTimeout();
        connectTimeout.ifPresent(duration -> this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)duration.toMillis())));
        for (Map.Entry entry : this.configuration.getChannelOptions().entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            String channelOption = (String)entry.getKey();
            this.bootstrap.option(ChannelOption.valueOf((String)NameUtils.underscoreSeparate((String)channelOption).toUpperCase(Locale.ENGLISH)), v);
        }
        this.bootstrap.resolver(this.resolverGroup);
    }

    @NonNull
    static AddressResolverGroup<? extends SocketAddress> getResolver(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull HttpClientConfiguration.DnsResolutionMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case HttpClientConfiguration.DnsResolutionMode.DEFAULT -> DefaultAddressResolverGroup.INSTANCE;
            case HttpClientConfiguration.DnsResolutionMode.NOOP -> NoopAddressResolverGroup.INSTANCE;
            case HttpClientConfiguration.DnsResolutionMode.ROUND_ROBIN -> new AddressResolverGroup<InetSocketAddress>(){

                protected AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) {
                    return new InetSocketAddressResolver(executor, (NameResolver)new RoundRobinInetAddressResolver(executor, (NameResolver)new DefaultNameResolver(executor)));
                }
            };
        };
    }

    public final void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            for (PoolHolder pool : this.pools.values()) {
                pool.shutdown();
            }
            this.pools.clear();
            if (this.shutdownGroup) {
                Duration shutdownTimeout = this.configuration.getShutdownTimeout().orElse(Duration.ofMillis(100L));
                Duration shutdownQuietPeriod = this.configuration.getShutdownQuietPeriod().orElse(Duration.ofMillis(1L));
                Future future = this.group.shutdownGracefully(shutdownQuietPeriod.toMillis(), shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS);
                try {
                    future.await(shutdownTimeout.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.sslContextWrapper.clear();
            this.sslContextWrapperWs.clear();
            this.resolverGroup.close();
        }
    }

    public final boolean isRunning() {
        return this.running.get() && !this.group.isShutdown();
    }

    ChannelFuture doConnect(DefaultHttpClient.RequestKey requestKey, CustomizerAwareInitializer channelInitializer, @NonNull EventLoopGroup eventLoop) {
        String host = requestKey.getHost();
        int port = requestKey.getPort();
        Bootstrap localBootstrap = this.bootstrap.clone();
        Proxy proxy = this.configuration.resolveProxy(requestKey.isSecure(), host, port);
        if (proxy.type() != Proxy.Type.DIRECT) {
            localBootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
        ((Bootstrap)localBootstrap.handler((ChannelHandler)channelInitializer)).remoteAddress(host, port).group(eventLoop);
        channelInitializer.bootstrappedCustomizer = this.clientCustomizer.specializeForBootstrap(localBootstrap);
        return localBootstrap.connect();
    }

    @Nullable
    private SslContext buildSslContext(DefaultHttpClient.RequestKey requestKey) {
        SslContext sslCtx;
        if (requestKey.isSecure()) {
            SslContextHolder holder = this.sslContextWrapper.takeRetained();
            SslContext sslContext = sslCtx = holder == null ? null : holder.sslContext();
            if (sslCtx == null && !this.configuration.getProxyAddress().isPresent()) {
                throw this.decorate(new HttpClientException("Cannot send HTTPS request. SSL is disabled"));
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    public final ExecutionFlow<PoolHandle> connect(DefaultHttpClient.RequestKey requestKey, @Nullable BlockHint blockHint) {
        return this.connect(requestKey, blockHint, null);
    }

    public final ExecutionFlow<PoolHandle> connect(DefaultHttpClient.RequestKey requestKey, @Nullable BlockHint blockHint, @Nullable AtomicReference<ScheduledExecutorService> preferredScheduler) {
        return this.pools.computeIfAbsent(requestKey, rk -> this.createPool((DefaultHttpClient.RequestKey)rk, (Iterable<? extends EventExecutor>)this.group)).acquire(blockHint, preferredScheduler);
    }

    @Nullable
    private SslContext buildWebsocketSslContext(DefaultHttpClient.RequestKey requestKey) {
        if (requestKey.isSecure()) {
            if (this.configuration.getSslConfiguration().isEnabled()) {
                SslContextHolder holder;
                if (!this.wsContextLoaded) {
                    this.sslContextWrapperWs.autoLoad();
                    this.wsContextLoaded = true;
                }
                return (holder = this.sslContextWrapperWs.takeRetained()) == null ? null : holder.sslContext();
            }
            if (this.configuration.getProxyAddress().isEmpty()) {
                throw this.decorate(new HttpClientException("Cannot send WSS request. SSL is disabled"));
            }
        }
        return null;
    }

    final Mono<?> connectForWebsocket(final DefaultHttpClient.RequestKey requestKey, final ChannelHandler handler) {
        CancellableMonoSink initial = new CancellableMonoSink(null);
        ChannelFuture connectFuture = this.doConnect(requestKey, new CustomizerAwareInitializer((Sinks.Empty)initial){
            final /* synthetic */ Sinks.Empty val$initial;
            {
                this.val$initial = empty;
            }

            protected void initChannel(@NonNull Channel ch) {
                Duration duration;
                ConnectionManager.this.addLogHandler(ch);
                SslContext sslContext = ConnectionManager.this.buildWebsocketSslContext(requestKey);
                if (sslContext != null) {
                    try {
                        ch.pipeline().addLast(new ChannelHandler[]{ConnectionManager.this.configureSslHandler(sslContext.newHandler(ch.alloc(), requestKey.getHost(), requestKey.getPort()))});
                    }
                    finally {
                        ReferenceCountUtil.release((Object)sslContext);
                    }
                }
                ch.pipeline().addLast("http-client-codec", (ChannelHandler)new HttpClientCodec(4096, ConnectionManager.this.configuration.getMaxHeaderSize(), 8192)).addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(ConnectionManager.this.configuration.getMaxContentLength()));
                Optional readIdleTime = ConnectionManager.this.configuration.getReadIdleTimeout();
                if (readIdleTime.isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                    ch.pipeline().addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                }
                try {
                    if (ConnectionManager.this.configuration.getWebSocketCompressionConfiguration() != null && ConnectionManager.this.configuration.getWebSocketCompressionConfiguration().isEnabled()) {
                        ch.pipeline().addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
                    }
                    ch.pipeline().addLast("micronaut-websocket-client", handler);
                    this.bootstrappedCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION).onInitialPipelineBuilt();
                    if (this.val$initial.tryEmitEmpty().isSuccess()) {
                        return;
                    }
                }
                catch (Throwable e) {
                    this.val$initial.tryEmitError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + e.getMessage(), e));
                }
                ch.close();
            }
        }, this.group);
        this.withPropagation((Future)connectFuture, (GenericFutureListener)future -> {
            if (!future.isSuccess()) {
                initial.tryEmitError(future.cause());
            }
        });
        return initial.asMono();
    }

    private void configureProxy(ChannelPipeline pipeline, boolean secure, String host, int port) {
        InetSocketAddress isa;
        Proxy proxy = this.configuration.resolveProxy(secure, host, port);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return;
        }
        Proxy.Type proxyType = proxy.type();
        SocketAddress proxyAddress = proxy.address();
        String username = this.configuration.getProxyUsername().orElse(null);
        String password = this.configuration.getProxyPassword().orElse(null);
        if (proxyAddress instanceof InetSocketAddress && (isa = (InetSocketAddress)proxyAddress).isUnresolved()) {
            proxyAddress = new InetSocketAddress(isa.getHostString(), isa.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress, username, password));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress, username, password));
                    break;
                }
            }
        } else {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress));
                    break;
                }
            }
        }
    }

    final <V, C extends Future<V>> void withPropagation(Future<? extends V> channelFuture, GenericFutureListener<C> listener) {
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        channelFuture.addListener(f -> {
            try (PropagatedContext.Scope ignored = propagatedContext.propagate();){
                listener.operationComplete(f);
            }
        });
    }

    private Http2FrameCodec makeFrameCodec() {
        Http2FrameCodecBuilder builder = Http2FrameCodecBuilder.forClient();
        this.configuration.getLogLevel().ifPresent(logLevel -> {
            try {
                LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                builder.frameLogger(new Http2FrameLogger(nettyLevel, DefaultHttpClient.class));
            }
            catch (IllegalArgumentException e) {
                throw this.decorate(new HttpClientException("Unsupported log level: " + String.valueOf(logLevel)));
            }
        });
        return builder.build();
    }

    private SslHandler configureSslHandler(SslHandler sslHandler) {
        sslHandler.setHandshakeTimeoutMillis(this.configuration.getSslConfiguration().getHandshakeTimeout().toMillis());
        SSLEngine engine = sslHandler.engine();
        SSLParameters params = engine.getSSLParameters();
        params.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(params);
        return sslHandler;
    }

    private void initHttp1(Channel ch) {
        this.addLogHandler(ch);
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("http-client-codec", (ChannelHandler)new HttpClientCodec(4096, this.configuration.getMaxHeaderSize(), 8192));
        if (this.configuration.isDecompressionEnabled()) {
            pipeline.addLast("http-decoder", (ChannelHandler)new HttpContentDecompressor());
        }
    }

    private void addLogHandler(Channel ch) {
        this.configuration.getLogLevel().ifPresent(logLevel -> {
            try {
                LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(DefaultHttpClient.class, nettyLevel)});
            }
            catch (IllegalArgumentException e) {
                throw this.decorate(new HttpClientException("Unsupported log level: " + String.valueOf(logLevel)));
            }
        });
    }

    private void insertPcapLoggingHandlerLazy(final Channel ch, final String qualifier) {
        if (this.configuration.getPcapLoggingPathPattern() == null) {
            return;
        }
        if (ch.isActive()) {
            ChannelHandler actual = this.createPcapLoggingHandler(ch, qualifier);
            ch.pipeline().addLast("pcap-" + qualifier, actual);
        } else {
            ch.pipeline().addLast(new ChannelHandler[]{new ActivityHandler(){

                @Override
                public void channelActive0(ChannelHandlerContext ctx) throws Exception {
                    ChannelHandler actual = ConnectionManager.this.createPcapLoggingHandler(ch, qualifier);
                    ctx.pipeline().addBefore(ctx.name(), "pcap-" + qualifier, actual);
                    ctx.pipeline().remove(ctx.name());
                }
            }});
        }
    }

    @Nullable
    private ChannelHandler createPcapLoggingHandler(Channel ch, String qualifier) {
        String pattern = this.configuration.getPcapLoggingPathPattern();
        if (pattern == null) {
            return null;
        }
        String path = pattern;
        path = path.replace("{qualifier}", qualifier);
        if (ch.localAddress() != null) {
            path = path.replace("{localAddress}", this.resolveIfNecessary(ch.localAddress()));
        }
        if (ch.remoteAddress() != null) {
            path = path.replace("{remoteAddress}", this.resolveIfNecessary(ch.remoteAddress()));
        }
        if (this.udpBootstrap != null && ch instanceof QuicStreamChannel) {
            QuicStreamChannel qsc = (QuicStreamChannel)ch;
            path = path.replace("{localAddress}", this.resolveIfNecessary(qsc.parent().localSocketAddress()));
            path = path.replace("{remoteAddress}", this.resolveIfNecessary(qsc.parent().remoteSocketAddress()));
        }
        path = path.replace("{random}", Long.toHexString(ThreadLocalRandom.current().nextLong()));
        path = path.replace("{timestamp}", Instant.now().toString());
        path = path.replace(':', '_');
        this.log.warn("Logging *full* request data, as configured. This will contain sensitive information! Path: '{}'", (Object)path);
        try {
            PcapWriteHandler.Builder builder = PcapWriteHandler.builder();
            if (this.udpBootstrap != null && ch instanceof QuicStreamChannel) {
                QuicStreamChannel qsc = (QuicStreamChannel)ch;
                builder.forceTcpChannel((InetSocketAddress)qsc.parent().localSocketAddress(), (InetSocketAddress)qsc.parent().remoteSocketAddress(), true);
            }
            return builder.build((OutputStream)new FileOutputStream(path));
        }
        catch (FileNotFoundException e) {
            this.log.warn("Failed to create target pcap at '{}', not logging.", (Object)path, (Object)e);
            return null;
        }
    }

    private String resolveIfNecessary(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)address;
            if (socketAddress.isUnresolved() && (socketAddress = new InetSocketAddress(socketAddress.getHostString(), socketAddress.getPort())).isUnresolved()) {
                return "unresolved";
            }
            return socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
        }
        String s = address.toString();
        if (s.contains("/")) {
            return "weird";
        }
        return s;
    }

    private void initHttp2(PoolHolder pool, Channel ch, NettyClientCustomizer connectionCustomizer) {
        Http2MultiplexHandler multiplexHandler = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(@NonNull Http2StreamChannel ch) throws Exception {
                ConnectionManager.this.log.warn("Server opened HTTP2 stream {}, closing immediately", (Object)ch.stream().id());
                ch.close();
            }
        }, (ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

            protected void initChannel(@NonNull Http2StreamChannel ch) throws Exception {
                ch.close();
            }
        });
        PoolHolder poolHolder = pool;
        Objects.requireNonNull(poolHolder);
        final PoolHolder.Http2ConnectionHolder connectionHolder = poolHolder.new PoolHolder.Http2ConnectionHolder(ch, connectionCustomizer);
        ch.pipeline().addLast(new ChannelHandler[]{multiplexHandler});
        ch.pipeline().addLast("http2-settings", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
                if (msg instanceof Http2SettingsFrame) {
                    ctx.pipeline().remove("http2-settings");
                    ctx.pipeline().remove("initial-error");
                    connectionHolder.init();
                    return;
                }
                ConnectionManager.this.log.warn("Premature frame: {}", msg.getClass());
                super.channelRead(ctx, msg);
            }
        });
        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                ctx.read();
            }

            public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
                if (msg instanceof Http2SettingsAckFrame || msg instanceof Http2PingFrame) {
                    return;
                }
                if (msg instanceof Http2GoAwayFrame) {
                    Http2GoAwayFrame goAway = (Http2GoAwayFrame)msg;
                    connectionHolder.windDownConnection();
                    if (ConnectionManager.this.log.isDebugEnabled()) {
                        byte[] debug = new byte[Math.min(64, goAway.content().readableBytes())];
                        goAway.content().readBytes(debug);
                        ConnectionManager.this.log.debug("Server sent GOAWAY frame. errorCode={} base64(content)={}", (Object)goAway.errorCode(), (Object)Base64.getEncoder().encodeToString(debug));
                    }
                    goAway.release();
                    return;
                }
                ConnectionManager.this.log.warn("Unexpected message on HTTP2 connection channel: {}", msg);
                ReferenceCountUtil.release((Object)msg);
                ctx.read();
            }
        }});
    }

    private <E extends HttpClientException> E decorate(E exc) {
        return (E)HttpClientExceptionUtils.populateServiceId(exc, (String)this.informationalServiceId, (HttpClientConfiguration)this.configuration);
    }

    PoolHolder createPool(DefaultHttpClient.RequestKey requestKey, Iterable<? extends EventExecutor> group) {
        return new PoolHolder(requestKey, group);
    }

    private final class ClientContextWrapper
    extends SslContextAutoLoader {
        private final boolean ws;

        ClientContextWrapper(boolean ws) {
            super(ConnectionManager.this.log);
            this.ws = ws;
        }

        @NonNull
        protected BeanProvider<CertificateProvider> certificateProviders() {
            return ConnectionManager.this.certificateProviders;
        }

        @NonNull
        protected SslConfiguration sslConfiguration() {
            return ConnectionManager.this.configuration.getSslConfiguration();
        }

        protected boolean quic() {
            return !this.ws && ConnectionManager.this.httpVersion.isHttp3();
        }

        @NonNull
        protected SslContextHolder createLegacy() {
            if (this.quic()) {
                return new SslContextHolder(null, (Object)ConnectionManager.this.nettyClientSslBuilder.buildHttp3(ConnectionManager.this.configuration.getSslConfiguration()));
            }
            return new SslContextHolder(ConnectionManager.this.nettyClientSslBuilder.build(ConnectionManager.this.configuration.getSslConfiguration(), this.ws ? HttpVersionSelection.forLegacyVersion((HttpVersion)HttpVersion.HTTP_1_1) : ConnectionManager.this.httpVersion), null);
        }

        @NonNull
        protected NettySslContextBuilder builder() {
            AbstractClientSslConfiguration acsc;
            NettySslContextBuilder builder = ConnectionManager.this.sslFactory.builder(ConnectionManager.this.configuration);
            if (ConnectionManager.this.httpVersion.isHttp2CipherSuites()) {
                builder.http2();
            }
            if (ConnectionManager.this.httpVersion.isAlpn()) {
                builder.alpnProtocols(List.of(ConnectionManager.this.httpVersion.getAlpnSupportedProtocols()));
            } else {
                builder.alpnProtocols(null);
            }
            SslConfiguration sslConfiguration = this.sslConfiguration();
            if (sslConfiguration instanceof AbstractClientSslConfiguration && (acsc = (AbstractClientSslConfiguration)sslConfiguration).isInsecureTrustAllCertificates()) {
                if (ConnectionManager.this.log.isWarnEnabled()) {
                    ConnectionManager.this.log.warn("HTTP Client is configured to trust all certificates ('insecure-trust-all-certificates' is set to true). Trusting all certificates is not secure and should not be used in production.");
                }
                builder.trustAll(true);
            }
            return builder;
        }
    }

    final class PoolHolder
    implements Pool.Listener {
        final Pool pool;
        private final DefaultHttpClient.RequestKey requestKey;
        private final InitialConnectionErrorHandler initialErrorHandler = new InitialConnectionErrorHandler(){

            @Override
            protected void onNewConnectionFailure(@NonNull EventLoop eventLoop, @Nullable Throwable cause) throws Exception {
                PoolHolder.this.pool.onNewConnectionFailure(eventLoop, cause);
            }
        };

        PoolHolder(DefaultHttpClient.RequestKey requestKey, Iterable<? extends EventExecutor> group) {
            this.requestKey = requestKey;
            this.pool = switch (ConnectionManager.this.configuration.getConnectionPoolConfiguration().getVersion()) {
                default -> throw new IncompatibleClassChangeError();
                case HttpClientConfiguration.ConnectionPoolConfiguration.PoolVersion.V4_0 -> new Pool40(this, ConnectionManager.this.log, ConnectionManager.this.configuration.getConnectionPoolConfiguration(), (EventLoopGroup)group);
                case HttpClientConfiguration.ConnectionPoolConfiguration.PoolVersion.V4_9 -> new Pool49(this, ConnectionManager.this.log, ConnectionManager.this.configuration.getConnectionPoolConfiguration(), group);
            };
        }

        ExecutionFlow<PoolHandle> acquire(@Nullable BlockHint blockHint, @Nullable AtomicReference<ScheduledExecutorService> preferredScheduler) {
            Optional acquireTimeout;
            EventExecutor destPool;
            Pool.PendingRequest sink = this.pool.createPendingRequest(blockHint);
            sink.dispatch();
            if (preferredScheduler != null && (destPool = sink.likelyEventLoop()) != null) {
                preferredScheduler.set((ScheduledExecutorService)destPool);
            }
            if ((acquireTimeout = ConnectionManager.this.configuration.getConnectionPoolConfiguration().getAcquireTimeout()).isPresent()) {
                return sink.flow().timeout((Duration)acquireTimeout.get(), (ScheduledExecutorService)ConnectionManager.this.group, (v, e) -> {
                    if (v != null) {
                        v.release();
                    }
                });
            }
            return sink.flow();
        }

        @Override
        public Throwable wrapError(@Nullable Throwable error) {
            HttpClientException wrapped = error == null ? new HttpClientException("Unknown connect error") : new HttpClientException("Connect Error: " + error.getMessage(), error);
            return wrapped;
        }

        @Override
        public void openNewConnection(@NonNull EventLoop eventLoop) {
            ChannelFuture channelFuture = this.openConnectionFuture(eventLoop);
            ConnectionManager.this.withPropagation(channelFuture, future -> {
                if (!future.isSuccess()) {
                    this.pool.onNewConnectionFailure(eventLoop, future.cause());
                }
            });
        }

        private ChannelFuture openConnectionFuture(@NonNull EventLoop eventLoop) {
            CustomizerAwareInitializer initializer;
            if (this.requestKey.isSecure()) {
                if (ConnectionManager.this.httpVersion.isHttp3()) {
                    Http3ChannelInitializer channelInitializer = new Http3ChannelInitializer(this, this.requestKey.getHost(), this.requestKey.getPort());
                    Bootstrap localBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)ConnectionManager.this.udpBootstrap.clone().handler((ChannelHandler)channelInitializer)).localAddress(0)).group((EventLoopGroup)eventLoop);
                    channelInitializer.bootstrappedCustomizer = ConnectionManager.this.clientCustomizer.specializeForBootstrap(localBootstrap);
                    return localBootstrap.bind();
                }
                initializer = new AdaptiveAlpnChannelInitializer(this, () -> ConnectionManager.this.buildSslContext(this.requestKey), this.requestKey.getHost(), this.requestKey.getPort());
            } else {
                initializer = switch (ConnectionManager.this.httpVersion.getPlaintextMode()) {
                    default -> throw new IncompatibleClassChangeError();
                    case HttpVersionSelection.PlaintextMode.HTTP_1 -> new CustomizerAwareInitializer(){

                        protected void initChannel(final @NonNull Channel ch) throws Exception {
                            ConnectionManager.this.insertPcapLoggingHandlerLazy(ch, "outer");
                            ConnectionManager.this.configureProxy(ch.pipeline(), false, PoolHolder.this.requestKey.getHost(), PoolHolder.this.requestKey.getPort());
                            ConnectionManager.this.initHttp1(ch);
                            ch.pipeline().addLast("activity-listener", (ChannelHandler)new ActivityHandler(){

                                @Override
                                public void channelActive0(@NonNull ChannelHandlerContext ctx) throws Exception {
                                    ctx.pipeline().remove((ChannelHandler)this);
                                    NettyClientCustomizer channelCustomizer = bootstrappedCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
                                    new Http1ConnectionHolder(ch, channelCustomizer).init(true);
                                }
                            });
                        }
                    };
                    case HttpVersionSelection.PlaintextMode.H2C -> new Http2UpgradeInitializer(this);
                };
            }
            return ConnectionManager.this.doConnect(this.requestKey, initializer, (EventLoopGroup)eventLoop);
        }

        public void shutdown() {
            this.pool.forEachConnection(c -> ((ConnectionHolder)c).channel.close());
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        abstract class ConnectionHolder
        implements Pool.ResizerConnection {
            final Channel channel;
            final NettyClientCustomizer connectionCustomizer;
            @Nullable
            ScheduledFuture<?> ttlFuture;
            volatile boolean windDownConnection = false;
            private ReadTimeoutHandler readTimeoutHandler;

            ConnectionHolder(Channel channel, NettyClientCustomizer connectionCustomizer) {
                this.channel = channel;
                this.connectionCustomizer = connectionCustomizer;
            }

            private void resetReadTimeout() {
                if (this.readTimeoutHandler != null) {
                    this.readTimeoutHandler.resetReadTimeout();
                }
            }

            final void addTimeoutHandlers(String before) {
                ConnectionManager.this.configuration.getReadTimeout().ifPresent(dur -> {
                    ReadTimeoutHandler readTimeoutHandler;
                    this.readTimeoutHandler = readTimeoutHandler = new ReadTimeoutHandler(dur.toNanos(), TimeUnit.NANOSECONDS){

                        protected void readTimedOut(ChannelHandlerContext ctx) {
                            if (ConnectionHolder.this.hasLiveRequests()) {
                                ConnectionHolder.this.windDownConnection = true;
                                ConnectionHolder.this.fireReadTimeout(ctx);
                                ctx.close();
                            }
                        }
                    };
                    this.channel.pipeline().addBefore(before, "read-timeout", (ChannelHandler)readTimeoutHandler);
                });
                ConnectionManager.this.configuration.getConnectionPoolIdleTimeout().ifPresent(dur -> this.channel.pipeline().addBefore(before, "idle-state", (ChannelHandler)new ReadTimeoutHandler(dur.toNanos(), TimeUnit.NANOSECONDS){

                    protected void readTimedOut(ChannelHandlerContext ctx) {
                        if (!ConnectionHolder.this.hasLiveRequests()) {
                            ConnectionHolder.this.windDownConnection = true;
                            ctx.close();
                        }
                    }
                }));
                ConnectionManager.this.configuration.getConnectTtl().ifPresent(ttl -> {
                    this.ttlFuture = this.channel.eventLoop().schedule(this::windDownConnection, ttl.toNanos(), TimeUnit.NANOSECONDS);
                });
                this.channel.pipeline().addBefore(before, "connection-cleaner", (ChannelHandler)new ChannelInboundHandlerAdapter(){
                    boolean inactiveCalled = false;

                    public void channelInactive(@NonNull ChannelHandlerContext ctx) throws Exception {
                        super.channelInactive(ctx);
                        if (!this.inactiveCalled) {
                            this.inactiveCalled = true;
                            ConnectionHolder.this.onInactive();
                        }
                    }

                    public void handlerRemoved(ChannelHandlerContext ctx) {
                        if (!this.inactiveCalled) {
                            this.inactiveCalled = true;
                            ConnectionHolder.this.onInactive();
                        }
                    }
                });
            }

            void windDownConnection() {
                this.windDownConnection = true;
            }

            final void emitPoolHandle(Pool.PendingRequest sink, PoolHandle ph) {
                if (!sink.tryComplete(ph)) {
                    ph.release();
                } else if (!ConnectionManager.this.configuration.getConnectionPoolConfiguration().isEnabled()) {
                    this.windDownConnection();
                }
            }

            @Override
            public final void dispatch(Pool.PendingRequest sink) {
                if (this.channel.eventLoop().inEventLoop()) {
                    this.resetReadTimeout();
                    this.dispatch0(sink);
                } else {
                    this.channel.eventLoop().execute(() -> {
                        this.resetReadTimeout();
                        this.dispatch0(sink);
                    });
                }
            }

            abstract void dispatch0(Pool.PendingRequest var1);

            abstract boolean hasLiveRequests();

            abstract void fireReadTimeout(ChannelHandlerContext var1);

            void onInactive() {
                if (this.ttlFuture != null) {
                    this.ttlFuture.cancel(false);
                }
                this.windDownConnection = true;
            }
        }

        final class Http3ConnectionHolder
        extends Http2ConnectionHolder {
            private final Channel udpChannel;
            private final QuicChannel quicChannel;

            Http3ConnectionHolder(Channel channel, QuicChannel quicChannel, NettyClientCustomizer customizer) {
                super((Channel)quicChannel, customizer);
                this.udpChannel = channel;
                this.quicChannel = quicChannel;
            }

            @Override
            void adaptHeaders(Object msg) {
                if (msg instanceof Http3HeadersFrame) {
                    Http3HeadersFrame hf = (Http3HeadersFrame)msg;
                    if (PoolHolder.this.requestKey.isSecure()) {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTPS.name());
                    } else {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTP.name());
                    }
                }
            }

            @Override
            void addTimeoutHandlers() {
                this.addTimeoutHandlers("http2-connection");
            }

            @Override
            ChannelHandler createFrameToHttpObjectCodec() {
                return new Http3FrameToHttpObjectCodec(false);
            }

            @Override
            Future<? extends Channel> openStreamChannel() {
                return Http3.newRequestStream((QuicChannel)this.quicChannel, (ChannelHandler)new Http3RequestStreamInitializer(){

                    protected void initRequestStream(QuicStreamChannel ch) {
                    }
                });
            }

            @Override
            void onInactive() {
                super.onInactive();
                this.udpChannel.close();
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        class Http2ConnectionHolder
        extends ConnectionHolder {
            private final Pool.Http2PoolEntry poolEntry;
            private final AtomicInteger liveRequests;

            Http2ConnectionHolder(Channel channel, NettyClientCustomizer customizer) {
                super(channel, customizer);
                this.liveRequests = new AtomicInteger(0);
                this.poolEntry = PoolHolder.this.pool.createHttp2PoolEntry(channel.eventLoop(), this);
            }

            void init() {
                this.addTimeoutHandlers();
                this.connectionCustomizer.onStreamPipelineBuilt();
                this.poolEntry.onConnectionEstablished(ConnectionManager.this.configuration.getConnectionPoolConfiguration().getMaxConcurrentRequestsPerHttp2Connection());
            }

            void addTimeoutHandlers() {
                this.addTimeoutHandlers(PoolHolder.this.requestKey.isSecure() ? "ssl" : "http2-connection");
                HttpClientConfiguration.Http2ClientConfiguration http2Configuration = ConnectionManager.this.configuration.getHttp2Configuration();
                if (http2Configuration != null) {
                    long read = Http2ConnectionHolder.toNanos(http2Configuration.getPingIntervalRead());
                    long write = Http2ConnectionHolder.toNanos(http2Configuration.getPingIntervalWrite());
                    long idle = Http2ConnectionHolder.toNanos(http2Configuration.getPingIntervalIdle());
                    if (read > 0L || write > 0L || idle > 0L) {
                        this.channel.pipeline().addAfter("http2-connection", "http2-ping-sender", (ChannelHandler)new Http2PingSender(read, write, idle, TimeUnit.NANOSECONDS));
                    }
                }
            }

            private static long toNanos(@Nullable Duration timeout) {
                if (timeout == null) {
                    return 0L;
                }
                long nanos = timeout.toNanos();
                return nanos < 0L ? 0L : nanos;
            }

            @Override
            boolean hasLiveRequests() {
                return this.liveRequests.get() > 0;
            }

            @Override
            void fireReadTimeout(ChannelHandlerContext ctx) {
                this.channel.pipeline().fireExceptionCaught((Throwable)new Http2MultiplexActiveStreamsException((Throwable)ReadTimeoutException.INSTANCE));
            }

            @Override
            final void dispatch0(Pool.PendingRequest sink) {
                if (!this.channel.isActive() || this.windDownConnection) {
                    this.windDownConnection();
                    this.returnPendingRequest(sink);
                    return;
                }
                this.liveRequests.incrementAndGet();
                ConnectionManager.this.withPropagation(this.openStreamChannel(), future -> {
                    if (future.isSuccess()) {
                        final Channel streamChannel = (Channel)future.get();
                        ChannelPipeline streamPipeline = streamChannel.pipeline();
                        streamPipeline.addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                                Http2ConnectionHolder.this.adaptHeaders(msg);
                                super.write(ctx, msg, promise);
                            }
                        }}).addLast(new ChannelHandler[]{this.createFrameToHttpObjectCodec()});
                        if (ConnectionManager.this.configuration.isDecompressionEnabled()) {
                            streamPipeline.addLast("http-decompressor", (ChannelHandler)new HttpContentDecompressor());
                        }
                        final NettyClientCustomizer streamCustomizer = this.connectionCustomizer.specializeForChannel(streamChannel, NettyClientCustomizer.ChannelRole.HTTP2_STREAM);
                        PoolHandle ph = new PoolHandle(true, streamChannel){

                            @Override
                            public void taint() {
                                this.touch();
                            }

                            @Override
                            public void release() {
                                super.release();
                                streamChannel.close();
                                int newCount = Http2ConnectionHolder.this.liveRequests.decrementAndGet();
                                if (Http2ConnectionHolder.this.windDownConnection && newCount <= 0) {
                                    Http2ConnectionHolder.this.channel.close();
                                } else if (!Http2ConnectionHolder.this.windDownConnection) {
                                    Http2ConnectionHolder.this.poolEntry.markAvailable();
                                }
                            }

                            @Override
                            public boolean canReturn() {
                                return true;
                            }

                            @Override
                            public void notifyRequestPipelineBuilt() {
                                streamCustomizer.onRequestPipelineBuilt();
                            }
                        };
                        this.emitPoolHandle(sink, ph);
                    } else {
                        ConnectionManager.this.log.debug("Failed to open http2 stream", future.cause());
                        this.liveRequests.decrementAndGet();
                        this.returnPendingRequest(sink);
                    }
                });
            }

            @NonNull
            ChannelHandler createFrameToHttpObjectCodec() {
                return new Http2StreamFrameToHttpObjectCodec(false);
            }

            Future<? extends Channel> openStreamChannel() {
                return new Http2StreamChannelBootstrap(this.channel).open();
            }

            void adaptHeaders(Object msg) {
                if (msg instanceof Http2HeadersFrame) {
                    Http2HeadersFrame hf = (Http2HeadersFrame)msg;
                    if (PoolHolder.this.requestKey.isSecure()) {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTPS.name());
                    } else {
                        hf.headers().scheme((CharSequence)HttpScheme.HTTP.name());
                    }
                }
            }

            private void returnPendingRequest(Pool.PendingRequest sink) {
                if (!this.windDownConnection) {
                    this.poolEntry.markAvailable();
                }
                this.channel.eventLoop().execute(sink::redispatch);
            }

            @Override
            void windDownConnection() {
                super.windDownConnection();
                if (this.liveRequests.get() == 0) {
                    this.channel.close();
                }
                if (this.channel.eventLoop().inEventLoop()) {
                    this.poolEntry.markUnavailable();
                } else {
                    this.channel.eventLoop().execute(this.poolEntry::markUnavailable);
                }
            }

            @Override
            void onInactive() {
                super.onInactive();
                this.poolEntry.onConnectionInactive();
            }
        }

        final class Http1ConnectionHolder
        extends ConnectionHolder {
            private final Pool.Http1PoolEntry poolEntry;
            private volatile boolean hasLiveRequest;

            Http1ConnectionHolder(Channel channel, NettyClientCustomizer connectionCustomizer) {
                super(channel, connectionCustomizer);
                this.hasLiveRequest = false;
                this.poolEntry = PoolHolder.this.pool.createHttp1PoolEntry(channel.eventLoop(), this);
            }

            void init(boolean fireInitialPipelineBuilt) {
                this.addTimeoutHandlers(PoolHolder.this.requestKey.isSecure() ? "ssl" : "http-client-codec");
                if (fireInitialPipelineBuilt) {
                    this.connectionCustomizer.onInitialPipelineBuilt();
                }
                this.connectionCustomizer.onStreamPipelineBuilt();
                this.poolEntry.onConnectionEstablished();
            }

            @Override
            boolean hasLiveRequests() {
                return this.hasLiveRequest;
            }

            @Override
            void fireReadTimeout(ChannelHandlerContext ctx) {
                ctx.fireExceptionCaught((Throwable)ReadTimeoutException.INSTANCE);
            }

            @Override
            void dispatch0(Pool.PendingRequest sink) {
                if (!this.channel.isActive()) {
                    this.windDownConnection();
                    this.returnPendingRequest(sink);
                    return;
                }
                this.hasLiveRequest = true;
                PoolHandle ph = new PoolHandle(false, this.channel){
                    final ChannelHandlerContext lastContext;
                    {
                        this.lastContext = this.channel.pipeline().lastContext();
                    }

                    @Override
                    public void taint() {
                        Http1ConnectionHolder.this.windDownConnection = true;
                    }

                    @Override
                    public void release() {
                        ChannelHandlerContext newLast;
                        super.release();
                        if (!Http1ConnectionHolder.this.windDownConnection && this.lastContext != (newLast = this.channel.pipeline().lastContext())) {
                            ConnectionManager.this.log.warn("BUG - Handler not removed: {}", (Object)newLast);
                            this.taint();
                        }
                        if (!Http1ConnectionHolder.this.windDownConnection) {
                            Http1ConnectionHolder.this.hasLiveRequest = false;
                            Http1ConnectionHolder.this.poolEntry.markAvailable();
                        } else {
                            this.channel.close();
                        }
                    }

                    @Override
                    public boolean canReturn() {
                        return !Http1ConnectionHolder.this.windDownConnection;
                    }

                    @Override
                    public void notifyRequestPipelineBuilt() {
                        Http1ConnectionHolder.this.connectionCustomizer.onRequestPipelineBuilt();
                    }
                };
                this.emitPoolHandle(sink, ph);
            }

            private void returnPendingRequest(Pool.PendingRequest sink) {
                this.hasLiveRequest = false;
                if (!this.windDownConnection) {
                    this.poolEntry.markAvailable();
                }
                this.channel.eventLoop().execute(sink::redispatch);
            }

            @Override
            void windDownConnection() {
                super.windDownConnection();
                if (!this.hasLiveRequest) {
                    this.channel.close();
                }
                this.poolEntry.markUnavailable();
            }

            @Override
            void onInactive() {
                super.onInactive();
                this.poolEntry.onConnectionInactive();
            }
        }
    }

    static abstract class CustomizerAwareInitializer
    extends ChannelInitializer<Channel> {
        NettyClientCustomizer bootstrappedCustomizer;

        CustomizerAwareInitializer() {
        }
    }

    private static abstract class ActivityHandler
    extends ChannelInboundHandlerAdapter {
        private ActivityHandler() {
        }

        public final void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.fireChannelActive();
            this.channelActive0(ctx);
        }

        protected abstract void channelActive0(ChannelHandlerContext var1) throws Exception;

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            if (ctx.channel().isActive()) {
                this.channelActive0(ctx);
            }
        }
    }

    public static abstract class PoolHandle {
        private static final Supplier<ResourceLeakDetector<PoolHandle>> LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(PoolHandle.class));
        final boolean http2;
        final Channel channel;
        boolean released = false;
        private final ResourceLeakTracker<PoolHandle> tracker = LEAK_DETECTOR.get().track((Object)this);

        private PoolHandle(boolean http2, Channel channel) {
            this.http2 = http2;
            this.channel = channel;
        }

        public final Channel channel() {
            return this.channel;
        }

        public final boolean http2() {
            return this.http2;
        }

        public abstract void taint();

        public void release() {
            if (this.released) {
                throw new IllegalStateException("Already released");
            }
            this.released = true;
            if (this.tracker != null) {
                this.tracker.close((Object)this);
            }
        }

        public abstract boolean canReturn();

        public abstract void notifyRequestPipelineBuilt();

        public final void touch() {
            if (this.tracker != null) {
                this.tracker.record();
            }
        }
    }

    private final class Http3ChannelInitializer
    extends ChannelOutboundHandlerAdapter {
        private final PoolHolder pool;
        private final String host;
        private final int port;
        private NettyClientCustomizer bootstrappedCustomizer;

        Http3ChannelInitializer(PoolHolder pool, String host, int port) {
            this.pool = pool;
            this.host = host;
            this.port = port;
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            ChannelPromise downstreamPromise = ctx.newPromise();
            super.bind(ctx, localAddress, downstreamPromise);
            downstreamPromise.addListener(future -> {
                if (future.isSuccess()) {
                    try {
                        this.initChannel(promise.channel());
                        ctx.pipeline().remove((ChannelHandler)this);
                        promise.setSuccess();
                    }
                    catch (Exception e) {
                        promise.setFailure((Throwable)e);
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initChannel(final Channel ch) {
            final NettyClientCustomizer channelCustomizer = this.bootstrappedCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            ConnectionManager.this.insertPcapLoggingHandlerLazy(ch, "outer");
            QuicSslContext quicSslContext = ConnectionManager.this.sslContextWrapper.takeRetained().quicSslContext();
            try {
                ch.pipeline().addLast(new ChannelHandler[]{((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)Http3.newQuicClientCodecBuilder().sslEngineProvider(c -> quicSslContext.newEngine(c.alloc(), this.host, this.port))).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(1000000L)).build()}).addLast("initial-error", (ChannelHandler)this.pool.initialErrorHandler);
            }
            finally {
                ReferenceCountUtil.release((Object)quicSslContext);
            }
            channelCustomizer.onInitialPipelineBuilt();
            QuicChannel.newBootstrap((Channel)ch).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    final QuicChannel quicChannel = (QuicChannel)ctx.channel();
                    ctx.pipeline().addLast("http2-connection", (ChannelHandler)new Http3ClientConnectionHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            if (msg instanceof Http3SettingsFrame) {
                                ch.pipeline().remove("initial-error");
                                PoolHolder poolHolder = Http3ChannelInitializer.this.pool;
                                Objects.requireNonNull(poolHolder);
                                poolHolder.new PoolHolder.Http3ConnectionHolder(ch, quicChannel, channelCustomizer).init();
                            }
                            super.channelRead(ctx, msg);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            ch.pipeline().remove("initial-error");
                            ch.close();
                            Http3ChannelInitializer.this.pool.pool.onNewConnectionFailure(ctx.channel().eventLoop(), cause);
                        }
                    }, null, null, null, false));
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }).remoteAddress((SocketAddress)new InetSocketAddress(this.host, this.port)).localAddress(ch.localAddress()).connect().addListener(future -> {
                if (!future.isSuccess()) {
                    this.pool.pool.onNewConnectionFailure(ch.eventLoop(), future.cause());
                }
            });
        }
    }

    private final class Http2UpgradeInitializer
    extends CustomizerAwareInitializer {
        private final PoolHolder pool;

        Http2UpgradeInitializer(PoolHolder pool) {
            this.pool = pool;
        }

        protected void initChannel(@NonNull Channel ch) throws Exception {
            final NettyClientCustomizer connectionCustomizer = this.bootstrappedCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            ConnectionManager.this.insertPcapLoggingHandlerLazy(ch, "outer");
            final Http2FrameCodec frameCodec = ConnectionManager.this.makeFrameCodec();
            HttpClientCodec sourceCodec = new HttpClientCodec(4096, ConnectionManager.this.configuration.getMaxHeaderSize(), 8192);
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(frameCodec, (ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(@NonNull Channel ch) throws Exception {
                    ch.pipeline().addLast("http2-connection", (ChannelHandler)frameCodec);
                    ConnectionManager.this.initHttp2(Http2UpgradeInitializer.this.pool, ch, connectionCustomizer);
                }
            });
            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
            ch.pipeline().addLast("http-client-codec", (ChannelHandler)sourceCodec);
            ch.pipeline().addLast(new ChannelHandler[]{upgradeHandler});
            ch.pipeline().addLast("http2-upgrade-request", (ChannelHandler)new ActivityHandler(){

                @Override
                public void channelActive0(@NonNull ChannelHandlerContext ctx) throws Exception {
                    DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
                    upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(Http2UpgradeInitializer.this.pool.requestKey.getHost() + ":" + Http2UpgradeInitializer.this.pool.requestKey.getPort()));
                    ctx.writeAndFlush((Object)upgradeRequest);
                    ctx.pipeline().remove("http2-upgrade-request");
                    ctx.read();
                }
            });
            ch.pipeline().addLast("initial-error", (ChannelHandler)this.pool.initialErrorHandler);
            connectionCustomizer.onInitialPipelineBuilt();
        }
    }

    private final class AdaptiveAlpnChannelInitializer
    extends CustomizerAwareInitializer {
        private final PoolHolder pool;
        private final Supplier<SslContext> sslContext;
        private final String host;
        private final int port;

        AdaptiveAlpnChannelInitializer(PoolHolder pool, Supplier<SslContext> sslContext, String host, int port) {
            this.pool = pool;
            this.sslContext = sslContext;
            this.host = host;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initChannel(final @NonNull Channel ch) {
            final NettyClientCustomizer channelCustomizer = this.bootstrappedCustomizer.specializeForChannel(ch, NettyClientCustomizer.ChannelRole.CONNECTION);
            ConnectionManager.this.insertPcapLoggingHandlerLazy(ch, "outer");
            ConnectionManager.this.configureProxy(ch.pipeline(), true, this.host, this.port);
            SslContext sslContext = this.sslContext.get();
            try {
                ch.pipeline().addLast("ssl", (ChannelHandler)ConnectionManager.this.configureSslHandler(sslContext.newHandler(ch.alloc(), this.host, this.port)));
            }
            finally {
                ReferenceCountUtil.release((Object)sslContext);
            }
            ConnectionManager.this.insertPcapLoggingHandlerLazy(ch, "tls-unwrapped");
            ch.pipeline().addLast("http2-protocol-negotiator", (ChannelHandler)new ApplicationProtocolNegotiationHandler("http/1.1"){

                protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                    if ("h2".equals(protocol)) {
                        ctx.pipeline().addLast("http2-connection", (ChannelHandler)ConnectionManager.this.makeFrameCodec());
                        ConnectionManager.this.initHttp2(AdaptiveAlpnChannelInitializer.this.pool, ctx.channel(), channelCustomizer);
                    } else if ("http/1.1".equals(protocol)) {
                        ConnectionManager.this.initHttp1(ctx.channel());
                        PoolHolder poolHolder = AdaptiveAlpnChannelInitializer.this.pool;
                        Objects.requireNonNull(poolHolder);
                        poolHolder.new PoolHolder.Http1ConnectionHolder(ch, channelCustomizer).init(false);
                        ctx.pipeline().remove("initial-error");
                    } else {
                        ctx.close();
                        throw ConnectionManager.this.decorate(new HttpClientException("Unknown Protocol: " + protocol));
                    }
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    SslHandshakeCompletionEvent event;
                    if (evt instanceof SslHandshakeCompletionEvent && !(event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                        InitialConnectionErrorHandler.setFailureCause(ctx.channel(), event.cause());
                    }
                    super.userEventTriggered(ctx, evt);
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                        cause = cause.getCause();
                    }
                    ctx.fireExceptionCaught(cause);
                }
            }).addLast("initial-error", (ChannelHandler)this.pool.initialErrorHandler);
            channelCustomizer.onInitialPipelineBuilt();
        }
    }
}

