/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.RuntimeTypeInformation;
import io.micronaut.core.type.TypeVariableResolver;
import io.micronaut.core.util.AnsiColour;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public interface TypeInformation<T>
extends TypeVariableResolver,
AnnotationMetadataProvider,
Type {
    @NonNull
    public Class<T> getType();

    default public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    default public Class<?> getWrapperType() {
        if (this.isPrimitive()) {
            return ReflectionUtils.getWrapperType(this.getType());
        }
        return this.getType();
    }

    @Override
    @NonNull
    default public String getTypeName() {
        Object[] typeParameters = this.getTypeParameters();
        if (ArrayUtils.isNotEmpty(typeParameters)) {
            String typeName = this.getType().getTypeName();
            return typeName + "<" + Arrays.stream(typeParameters).map(TypeInformation::getTypeName).collect(Collectors.joining(",")) + ">";
        }
        return this.getType().getTypeName();
    }

    default public boolean isReactive() {
        return RuntimeTypeInformation.isReactive(this.getType());
    }

    default public boolean isWrapperType() {
        return RuntimeTypeInformation.isWrapperType(this.getType());
    }

    default public Argument<?> getWrappedType() {
        return RuntimeTypeInformation.getWrappedType(this);
    }

    default public boolean isCompletable() {
        return RuntimeTypeInformation.isCompletable(this.getType());
    }

    default public boolean isAsync() {
        Class<T> type = this.getType();
        return CompletionStage.class.isAssignableFrom(type);
    }

    default public boolean isAsyncOrReactive() {
        return this.isAsync() || this.isReactive();
    }

    default public boolean isContainerType() {
        Class<T> type = this.getType();
        return Map.class == type || DefaultArgument.CONTAINER_TYPES.contains(type.getName());
    }

    default public boolean hasTypeVariables() {
        return !this.getTypeVariables().isEmpty();
    }

    default public String getTypeString(boolean simple) {
        return this.getTypeString(simple ? TypeFormat.SIMPLE : TypeFormat.QUALIFIED);
    }

    default public String getBeanTypeString(@NonNull TypeFormat format) {
        return TypeFormat.getBeanTypeString(format, this.getType(), this.getTypeVariables(), this.getAnnotationMetadata());
    }

    @NonNull
    default public String getTypeString(@NonNull TypeFormat format) {
        Class<T> type = this.getType();
        return TypeFormat.getTypeString(format, type, this.getTypeVariables());
    }

    default public boolean isVoid() {
        Class<T> javaReturnType = this.getType();
        if (javaReturnType == Void.TYPE) {
            return true;
        }
        if (this.isCompletable()) {
            return true;
        }
        if (this.isReactive() || this.isAsync()) {
            return this.getFirstTypeVariable().filter(arg -> arg.getType() == Void.class).isPresent();
        }
        return false;
    }

    default public boolean isOptional() {
        Class<T> type = this.getType();
        return type == Optional.class;
    }

    default public boolean isSpecifiedSingle() {
        return RuntimeTypeInformation.isSpecifiedSingle(this.getType(), this);
    }

    @NonNull
    default public Type asType() {
        if (this.getTypeParameters().length == 0) {
            return this.getType();
        }
        return this.asParameterizedType();
    }

    @NonNull
    default public ParameterizedType asParameterizedType() {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])Arrays.stream(TypeInformation.this.getTypeParameters()).map(TypeInformation::asType).toArray(Type[]::new);
            }

            @Override
            public Type getRawType() {
                return TypeInformation.this.getType();
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public String getTypeName() {
                return TypeInformation.this.getTypeName();
            }

            public String toString() {
                return this.getTypeName();
            }

            public int hashCode() {
                return Arrays.hashCode(this.getActualTypeArguments()) ^ Objects.hashCode(this.getOwnerType()) ^ Objects.hashCode(this.getRawType());
            }

            public boolean equals(Object o) {
                if (o instanceof ParameterizedType) {
                    ParameterizedType that = (ParameterizedType)o;
                    if (this == that) {
                        return true;
                    }
                    return Objects.equals(this.getOwnerType(), that.getOwnerType()) && Objects.equals(this.getRawType(), that.getRawType()) && Arrays.equals(this.getActualTypeArguments(), that.getActualTypeArguments());
                }
                return false;
            }
        };
    }

    default public boolean isArray() {
        return this.getType().isArray();
    }

    @NonNull
    default public String getSimpleName() {
        return this.getType().getSimpleName();
    }

    default public boolean isProvider() {
        for (String type : DefaultArgument.PROVIDER_TYPES) {
            if (!this.getType().getName().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static enum TypeFormat {
        SIMPLE,
        QUALIFIED,
        SHORTENED,
        ANSI_SIMPLE,
        ANSI_QUALIFIED,
        ANSI_SHORTENED;

        private static final String ANN_CR = "io.micronaut.context.annotation.ConfigurationReader";

        @NonNull
        public static String getBeanTypeString(@NonNull TypeFormat typeFormat, @NonNull Argument<?> argument) {
            return TypeFormat.getBeanTypeString(typeFormat, argument.getType(), argument.getTypeVariables(), argument.getAnnotationMetadata());
        }

        public boolean isAnsi() {
            return this == ANSI_SIMPLE || this == ANSI_QUALIFIED || this == ANSI_SHORTENED;
        }

        public String formatAnnotation(String annotationRef) {
            int i = annotationRef.indexOf("(");
            String members = i > -1 ? annotationRef.substring(i) : "";
            annotationRef = i > -1 ? annotationRef.substring(0, i) : annotationRef;
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SIMPLE -> "@" + NameUtils.getSimpleName(annotationRef) + members;
                case QUALIFIED -> "@" + annotationRef + members;
                case SHORTENED -> "@" + NameUtils.getShortenedName(annotationRef) + members;
                case ANSI_SIMPLE -> AnsiColour.yellow("@" + NameUtils.getSimpleName(annotationRef)) + members;
                case ANSI_QUALIFIED -> AnsiColour.yellow("@" + annotationRef) + members;
                case ANSI_SHORTENED -> AnsiColour.yellow("@" + NameUtils.getShortenedName(annotationRef)) + members;
            };
        }

        @NonNull
        public static String getTypeString(@NonNull TypeFormat format, @NonNull Class<?> type, @NonNull Map<String, Argument<?>> generics) {
            String typeName = switch (format) {
                default -> throw new IncompatibleClassChangeError();
                case SIMPLE -> type.getSimpleName();
                case QUALIFIED -> type.getCanonicalName();
                case SHORTENED -> NameUtils.getShortenedName(type.getTypeName());
                case ANSI_SIMPLE -> AnsiColour.cyan(type.getSimpleName());
                case ANSI_QUALIFIED -> AnsiColour.cyan(type.getCanonicalName());
                case ANSI_SHORTENED -> AnsiColour.cyan(NameUtils.getShortenedName(type.getCanonicalName()));
            };
            StringBuilder returnType = new StringBuilder(typeName);
            if (!generics.isEmpty()) {
                returnType.append(format.isAnsi() ? AnsiColour.brightCyan("<") : "<").append(generics.values().stream().map(arg -> arg.getTypeString(format)).collect(Collectors.joining(", "))).append(format.isAnsi() ? AnsiColour.brightCyan(">") : ">");
            }
            return returnType.toString();
        }

        @NonNull
        public static String getBeanTypeString(@NonNull TypeFormat format, @NonNull Class<?> type, @NonNull Map<String, Argument<?>> generics, @NonNull AnnotationMetadata annotationMetadata) {
            Object typeFormat = TypeFormat.getTypeString(format, type, generics);
            Optional<String> q = annotationMetadata.getAnnotationNameByStereotype("jakarta.inject.Qualifier").map(qualifier -> {
                String name;
                if ("jakarta.inject.Named".equals(qualifier) && (name = (String)annotationMetadata.stringValue("jakarta.inject.Named").orElse(null)) != null) {
                    if (format.isAnsi()) {
                        return qualifier + "(" + AnsiColour.green("\"" + name + "\"") + ")";
                    }
                    return qualifier + "(\"" + name + "\")";
                }
                return qualifier;
            });
            Optional<String> s = annotationMetadata.getAnnotationNameByStereotype("jakarta.inject.Scope").map(scope -> {
                if ("jakarta.inject.Singleton".equals(scope)) {
                    scope = annotationMetadata.getAnnotationNameByStereotype((String)scope).orElse((String)scope);
                    String configuration = annotationMetadata.stringValue(ANN_CR, "prefix").orElse(null);
                    if (configuration != null) {
                        scope = format.isAnsi() ? (String)scope + "(" + AnsiColour.green("\"" + configuration + "\"") + ")" : (String)scope + "(\"" + configuration + "\")";
                    }
                }
                return scope;
            });
            if (s.isPresent()) {
                typeFormat = format.formatAnnotation(s.get()) + " " + (String)typeFormat;
            }
            if (q.isPresent()) {
                typeFormat = format.formatAnnotation(q.get()) + " " + (String)typeFormat;
            }
            return typeFormat;
        }
    }
}

