/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.order;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.order.Ordered;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class OrderUtil {
    public static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int order1 = OrderUtil.getOrder(o1);
            int order2 = OrderUtil.getOrder(o2);
            return Integer.compare(order1, order2);
        }
    };
    public static final Comparator<Object> COMPARATOR_ZERO = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int order1 = OrderUtil.getOrder(o1);
            int order2 = OrderUtil.getOrder(o2);
            return Integer.compare(order1, order2);
        }
    };
    public static final Comparator<Ordered> ORDERED_COMPARATOR = new Comparator<Ordered>(){

        @Override
        public int compare(Ordered o1, Ordered o2) {
            return Integer.compare(o1.getOrder(), o2.getOrder());
        }
    };
    public static final Comparator<Ordered> REVERSE_ORDERED_COMPARATOR = Collections.reverseOrder(ORDERED_COMPARATOR);
    public static final Comparator<Object> REVERSE_COMPARATOR = Collections.reverseOrder(COMPARATOR);
    public static final Comparator<Object> REVERSE_COMPARATOR_ZERO = Collections.reverseOrder(COMPARATOR_ZERO);

    public static void sort(List<?> list) {
        list.sort(COMPARATOR);
    }

    public static <T> Stream<T> sort(Stream<T> list) {
        return list.sorted(COMPARATOR);
    }

    public static <T extends Ordered> Stream<T> sortOrdered(Stream<T> list) {
        return list.sorted(ORDERED_COMPARATOR);
    }

    public static <T extends Ordered> List<T> sortOrderedCollection(Collection<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.sort(ORDERED_COMPARATOR);
        return newList;
    }

    public static <T extends Ordered> void sortOrdered(List<T> list) {
        list.sort(ORDERED_COMPARATOR);
    }

    public static <T extends Ordered> void reverseSortOrdered(List<T> list) {
        list.sort(REVERSE_ORDERED_COMPARATOR);
    }

    public static void reverseSort(List<?> list) {
        list.sort(REVERSE_COMPARATOR);
    }

    public static void reverseSort(Object[] array) {
        Arrays.sort(array, REVERSE_COMPARATOR);
    }

    public static void sort(Ordered ... objects) {
        Arrays.sort(objects, COMPARATOR);
    }

    public static void sort(Object[] objects) {
        Arrays.sort(objects, COMPARATOR);
    }

    public static int getOrder(Object o) {
        return OrderUtil.getOrderWithDefaultPrecedence(o, Integer.MAX_VALUE);
    }

    public static int getOrderWithDefaultPrecedence(Object o, int defaultPrecedence) {
        if (o instanceof Ordered) {
            Ordered ordered = (Ordered)o;
            return ordered.getOrder();
        }
        if (o instanceof AnnotationMetadata) {
            AnnotationMetadata metadata = (AnnotationMetadata)o;
            return OrderUtil.getOrder(metadata);
        }
        return defaultPrecedence;
    }

    public static int getOrder(AnnotationMetadata annotationMetadata, Object o) {
        if (o instanceof Ordered) {
            Ordered ordered = (Ordered)o;
            return ordered.getOrder();
        }
        return OrderUtil.getOrder(annotationMetadata);
    }

    public static int getOrder(@NonNull AnnotationMetadata annotationMetadata) {
        return annotationMetadata.intValue(Order.class).orElse(0);
    }

    @Deprecated(since="4.4.0", forRemoval=true)
    public static int getOrder(Ordered o) {
        return o.getOrder();
    }
}

