/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.service;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.BuildTimeInit;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanInfo;
import io.micronaut.core.graal.GraalReflectionConfigurer;
import io.micronaut.core.io.service.MicronautMetaServiceLoaderUtils;
import io.micronaut.core.io.service.ServiceScanner;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

class ServiceLoaderFeature
implements Feature {
    ServiceLoaderFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.configureForReflection(access);
        ServiceScanner.StaticServiceDefinitions staticServiceDefinitions = this.buildStaticServiceDefinitions(access);
        Collection<Set<String>> allTypeNames = staticServiceDefinitions.serviceTypeMap().values();
        for (Set<String> typeNameSet : allTypeNames) {
            Iterator<String> i = typeNameSet.iterator();
            block5: while (i.hasNext()) {
                String typeName = i.next();
                try {
                    Class c = access.findClassByName(typeName);
                    if (c == null || GraalReflectionConfigurer.class.isAssignableFrom(c)) continue;
                    if (BeanInfo.class.isAssignableFrom(c)) {
                        AnnotationValue requirements;
                        BeanInfo beanInfo;
                        BuildTimeInit buildInit = c.getAnnotation(BuildTimeInit.class);
                        if (buildInit != null) {
                            String[] classNames;
                            for (String className : classNames = buildInit.value()) {
                                Class buildInitClass = access.findClassByName(className);
                                this.initializeAtBuildTime(buildInitClass);
                            }
                        }
                        try {
                            beanInfo = (BeanInfo)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            i.remove();
                            continue;
                        }
                        Class beanType = beanInfo.getBeanType();
                        List values = beanInfo.getAnnotationMetadata().getAnnotationValuesByName("io.micronaut.context.annotation.Requires");
                        if (values.isEmpty() && (requirements = beanInfo.getAnnotationMetadata().getAnnotation("io.micronaut.context.annotation.Requirements")) != null) {
                            values = requirements.getAnnotations("value");
                        }
                        if (!values.isEmpty()) {
                            for (AnnotationValue value : values) {
                                Object o;
                                String[] classNames = StringUtils.EMPTY_STRING_ARRAY;
                                if (value.contains("classes")) {
                                    classNames = value.stringValues("classes");
                                }
                                if (value.contains("beans")) {
                                    ArrayUtils.concat(classNames, value.stringValues("beans"));
                                }
                                if (value.contains("condition") && (o = value.getValues().get("condition")) instanceof AnnotationClassValue) {
                                    AnnotationClassValue annotationClassValue = (AnnotationClassValue)o;
                                    annotationClassValue.getType().ifPresent(this::initializeAtBuildTime);
                                }
                                for (String className : classNames) {
                                    if (access.findClassByName(className) != null) continue;
                                    i.remove();
                                    continue block5;
                                }
                            }
                        }
                    }
                    this.initializeAtBuildTime(c);
                    this.registerForReflectiveInstantiation(c);
                    this.registerRuntimeReflection(c);
                    Class exec = access.findClassByName(typeName + "$Exec");
                    if (exec == null) continue;
                    this.initializeAtBuildTime(exec);
                }
                catch (InstantiationException | NoClassDefFoundError e) {
                    i.remove();
                }
            }
        }
        this.addImageSingleton(staticServiceDefinitions);
    }

    protected void registerForReflectiveInstantiation(Class<?> c) {
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{c});
    }

    protected void addImageSingleton(ServiceScanner.StaticServiceDefinitions staticServiceDefinitions) {
        ImageSingletons.add(ServiceScanner.StaticServiceDefinitions.class, (Object)staticServiceDefinitions);
    }

    protected void registerRuntimeReflection(Class<?> c) {
        RuntimeReflection.register((Class[])new Class[]{c});
    }

    protected void registerRuntimeReflection(Method ... methods) {
        RuntimeReflection.register((Executable[])methods);
    }

    protected void registerRuntimeReflection(Field ... fields) {
        RuntimeReflection.register((Field[])fields);
    }

    protected void initializeAtBuildTime(@Nullable Class<?> buildInitClass) {
        if (buildInitClass != null) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{buildInitClass});
        }
    }

    @NonNull
    protected ServiceScanner.StaticServiceDefinitions buildStaticServiceDefinitions(Feature.BeforeAnalysisAccess access) {
        try {
            return new ServiceScanner.StaticServiceDefinitions(MicronautMetaServiceLoaderUtils.findAllMicronautMetaServices(this.getClass().getClassLoader()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void configureForReflection(final Feature.BeforeAnalysisAccess access) {
        Collection<GraalReflectionConfigurer> configurers = this.loadReflectionConfigurers(access);
        GraalReflectionConfigurer.ReflectionConfigurationContext context = new GraalReflectionConfigurer.ReflectionConfigurationContext(){

            @Override
            public Class<?> findClassByName(@NonNull String name) {
                return access.findClassByName(name);
            }

            @Override
            public void register(Class<?> ... types) {
                for (Class<?> type : types) {
                    ServiceLoaderFeature.this.registerRuntimeReflection(type);
                }
            }

            @Override
            public void register(Method ... methods) {
                ServiceLoaderFeature.this.registerRuntimeReflection(methods);
            }

            @Override
            public void register(Field ... fields) {
                ServiceLoaderFeature.this.registerRuntimeReflection(fields);
            }

            @Override
            public void register(Constructor<?> ... constructors) {
                RuntimeReflection.register((Executable[])constructors);
            }
        };
        for (GraalReflectionConfigurer configurer : configurers) {
            this.initializeAtBuildTime(configurer.getClass());
            configurer.configure(context);
        }
    }

    @NonNull
    protected Collection<GraalReflectionConfigurer> loadReflectionConfigurers(Feature.BeforeAnalysisAccess access) {
        ArrayList<GraalReflectionConfigurer> configurers = new ArrayList<GraalReflectionConfigurer>();
        SoftServiceLoader.load(GraalReflectionConfigurer.class, access.getApplicationClassLoader()).collectAll(configurers);
        return configurers;
    }
}

