/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.buffer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteArrayByteBuffer;
import io.micronaut.core.io.buffer.ByteBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public abstract class ReadBuffer
implements AutoCloseable {
    @Internal
    protected ReadBuffer() {
    }

    public abstract int readable();

    @NonNull
    public abstract ReadBuffer duplicate();

    @NonNull
    public abstract ReadBuffer split(int var1) throws IndexOutOfBoundsException;

    @NonNull
    public abstract ReadBuffer move();

    public abstract void toArray(byte @NonNull [] var1, int var2) throws IndexOutOfBoundsException;

    public byte @NonNull [] toArray() {
        byte[] bytes = new byte[this.readable()];
        this.toArray(bytes, 0);
        return bytes;
    }

    @NonNull
    public String toString(Charset charset) {
        return new String(this.toArray(), charset);
    }

    @NonNull
    public ByteBuffer<?> toByteBuffer() {
        return new ByteArrayByteBuffer(this.toArray());
    }

    @NonNull
    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.toArray());
    }

    public void transferTo(@NonNull OutputStream stream) throws IOException {
        stream.write(this.toArray());
    }

    @Override
    public abstract void close();

    protected abstract boolean isConsumed();

    protected abstract byte[] peekArray(int var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (this.isConsumed()) {
            sb.append("[consumed]");
        } else {
            byte[] bytes;
            int readable = this.readable();
            sb.append("[len=").append(readable).append(", data='");
            for (byte b : bytes = this.peekArray(Math.min(readable, 32))) {
                if (b < 32 || b > 126) {
                    sb.append("\\x");
                    int i = b & 0xFF;
                    if (i < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(i));
                    continue;
                }
                sb.append((char)b);
            }
            sb.append("'");
            if (readable > bytes.length) {
                sb.append('\u2026');
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

