/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.langchain4j.mongodb.atlas;

import com.mongodb.client.MongoClient;
import com.mongodb.client.model.CreateCollectionOptions;
import dev.langchain4j.store.embedding.mongodb.IndexMapping;
import dev.langchain4j.store.embedding.mongodb.MongoDbEmbeddingStore;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Nullable;
import java.util.Set;

@EachProperty(value="langchain4j.mongodb-atlas.embedding-stores", primary="default")
public class NamedMongoDbAtlasEmbeddingStoreConfig {
    public static final String PREFIX = "langchain4j.mongodb-atlas.embedding-stores";
    @ConfigurationBuilder(prefixes={""}, excludes={"fromClient", "mongoClient", "filter", "createCollectionOptions", "indexMapping"})
    final MongoDbEmbeddingStore.Builder builder;
    private final MongoClient mongoClient;

    public NamedMongoDbAtlasEmbeddingStoreConfig(@Parameter MongoClient mongoClient, @Parameter @Nullable IndexMappingConfig indexMappingConfig, @Parameter @Nullable CreateCollectionOptions createCollectionOptions) {
        this.mongoClient = mongoClient;
        this.builder = MongoDbEmbeddingStore.builder().fromClient(mongoClient).indexMapping(indexMappingConfig != null ? indexMappingConfig.indexMapping.build() : null).createCollectionOptions(createCollectionOptions);
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoDbEmbeddingStore.Builder getBuilder() {
        return this.builder;
    }

    @ConfigurationProperties(value="index-mapping")
    static class IndexMappingConfig {
        @ConfigurationBuilder(prefixes={""})
        final IndexMapping.Builder indexMapping = IndexMapping.builder().dimension(1536).metadataFieldNames(Set.of());
    }
}

