/*
 * Copyright 2017-2024 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.langchain4j.mongodb.atlas;

import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.mongodb.MongoDbEmbeddingStore;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;

@Factory
public class MongoDbAtlasEmbeddedStoreFactory {
    /**
     * Creates the embedding store for each named configuration.
     * @param config The config
     * @return The store
     */
    @EachBean(NamedMongoDbAtlasEmbeddingStoreConfig.class)
    @Context
    @Bean(typed = EmbeddingStore.class)
    protected MongoDbEmbeddingStore embeddingStore(NamedMongoDbAtlasEmbeddingStoreConfig config) {
        return config.getBuilder().build();
    }
}
