/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.langchain4j.elasticsearch;

import dev.langchain4j.store.embedding.elasticsearch.ElasticsearchEmbeddingStore;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.langchain4j.elasticsearch.CommonElasticsearchEmbeddingStoreConfiguration;
import jakarta.inject.Inject;
import org.elasticsearch.client.RestClient;

@ConfigurationProperties(value="langchain4j.elasticsearch.embedding-store")
@Context
@Requires(beans={CommonElasticsearchEmbeddingStoreConfiguration.class})
public class DefaultElasticsearchEmbeddingStoreConfiguration {
    public static final String PREFIX = "langchain4j.elasticsearch.embedding-store";
    @ConfigurationBuilder(prefixes={""}, excludes={"restClient"})
    ElasticsearchEmbeddingStore.Builder builder = ElasticsearchEmbeddingStore.builder();

    @ConfigurationInject
    public DefaultElasticsearchEmbeddingStoreConfiguration(CommonElasticsearchEmbeddingStoreConfiguration config) {
        this.builder.apiKey(config.apiKey());
        this.builder.serverUrl(config.serverUrl());
    }

    ElasticsearchEmbeddingStore.Builder getBuilder() {
        return this.builder;
    }

    @Inject
    protected void restClient(@Nullable RestClient restClient) {
        this.builder.restClient(restClient);
    }
}

