/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.langchain4j.openai;

import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.langchain4j.openai.CommonOpenAiChatModelConfiguration;

@EachProperty(value="langchain4j.open-ai.embedding-models")
@Context
@Requires(beans={CommonOpenAiChatModelConfiguration.class})
public class NamedOpenAiEmbeddingModelConfiguration {
    public static final String PREFIX = "langchain4j.open-ai.embedding-models";
    @ConfigurationBuilder(prefixes={""}, excludes={"proxy", "listeners", "tokenizer"})
    OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder builder = OpenAiEmbeddingModel.builder();

    @ConfigurationInject
    public NamedOpenAiEmbeddingModelConfiguration(@Bindable(defaultValue="text-embedding-ada-002") String modelName, CommonOpenAiChatModelConfiguration config) {
        this.builder.modelName(modelName);
        this.builder.baseUrl(config.baseUrl());
        this.builder.apiKey(config.apiKey());
        this.builder.organizationId(config.organizationId());
        this.builder.timeout(config.timeout());
        this.builder.logRequests(config.logRequests());
        this.builder.logResponses(config.logResponses());
    }

    OpenAiEmbeddingModel.OpenAiEmbeddingModelBuilder getBuilder() {
        return this.builder;
    }
}

