/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.langchain4j.openai;

import dev.langchain4j.model.openai.OpenAiImageModel;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.langchain4j.openai.CommonOpenAiChatModelConfiguration;

@ConfigurationProperties(value="langchain4j.open-ai.image-model")
@Context
@Requires(beans={CommonOpenAiChatModelConfiguration.class})
public class DefaultOpenAiImageModelConfiguration {
    public static final String PREFIX = "langchain4j.open-ai.image-model";
    @ConfigurationBuilder(prefixes={""}, excludes={"proxy", "listeners", "tokenizer"})
    OpenAiImageModel.OpenAiImageModelBuilder builder = OpenAiImageModel.builder();

    @ConfigurationInject
    public DefaultOpenAiImageModelConfiguration(@Bindable(defaultValue="dall-e-3") String modelName, CommonOpenAiChatModelConfiguration config) {
        this.builder.modelName(modelName);
        this.builder.baseUrl(config.baseUrl());
        this.builder.apiKey(config.apiKey());
        this.builder.organizationId(config.organizationId());
        this.builder.timeout(config.timeout());
        this.builder.logRequests(config.logRequests());
        this.builder.logResponses(config.logResponses());
    }

    OpenAiImageModel.OpenAiImageModelBuilder getBuilder() {
        return this.builder;
    }
}

