/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.langchain4j.openai;

import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.openai.OpenAiChatModel;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.langchain4j.openai.CommonOpenAiChatModelConfiguration;
import jakarta.inject.Inject;
import java.util.List;

@ConfigurationProperties(value="langchain4j.open-ai.chat-model")
@Context
@Requires(beans={CommonOpenAiChatModelConfiguration.class})
public class DefaultOpenAiChatModelConfiguration {
    public static final String PREFIX = "langchain4j.open-ai.chat-model";
    @ConfigurationBuilder(prefixes={""}, excludes={"proxy", "listeners", "tokenizer"})
    OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder();

    @ConfigurationInject
    public DefaultOpenAiChatModelConfiguration(@Bindable(defaultValue="gpt-3.5-turbo") String modelName, CommonOpenAiChatModelConfiguration config) {
        this.builder.modelName(modelName);
        this.builder.baseUrl(config.baseUrl());
        this.builder.apiKey(config.apiKey());
        this.builder.organizationId(config.organizationId());
        this.builder.timeout(config.timeout());
        this.builder.logRequests(config.logRequests());
        this.builder.logResponses(config.logResponses());
    }

    OpenAiChatModel.OpenAiChatModelBuilder getBuilder() {
        return this.builder;
    }

    @Inject
    protected void listeners(@Nullable List<ChatModelListener> listeners) {
        this.builder.listeners(listeners);
    }
}

