/*
 * Copyright 2017-2024 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.langchain4j.embedding;


import io.micronaut.context.annotation.EachProperty;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.util.StringUtils;

/**
 * Configuration for in-memory stores.
 *
 * @param enabled Whether it is enabled
 * @param path The path to the JSON file
 * @param json The JSON text
 */
@EachProperty(InMemoryEmbeddingStoreConfig.PREFIX)
public record InMemoryEmbeddingStoreConfig(
    @Bindable(defaultValue = StringUtils.TRUE)
    boolean enabled,
    @Nullable
    String path,

    @Nullable
    String json
) {
    public static final String PREFIX = "langchain4j.in-memory.embedding-stores";
}
