/*
 * Decompiled with CFR 0.152.
 */
package io.microlam.slf4j.simple;

import io.microlam.slf4j.simple.SimpleLogger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.spi.MDCAdapter;

public class SimpleLoggerFactory
implements ILoggerFactory {
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    MDCAdapter mdcAdapter;

    public SimpleLoggerFactory() {
        this(null);
    }

    public SimpleLoggerFactory(MDCAdapter mdcAdapter) {
        SimpleLogger.lazyInit();
        this.mdcAdapter = mdcAdapter;
    }

    public Logger getLogger(String name) {
        Logger simpleLogger = (Logger)this.loggerMap.get(name);
        if (simpleLogger != null) {
            return simpleLogger;
        }
        SimpleLogger newInstance = new SimpleLogger(name, this.mdcAdapter);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    void reset() {
        this.loggerMap.clear();
    }
}

